package org.jsmth.jorm.service;

import org.jsmth.domain.Identifier;
import org.jsmth.util.PropertyUtils;

import java.io.Serializable;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 2014/10/9
 * Time: 14:12
 */
public class ExtentServicePropertyMethod<KEY extends Serializable, MODEL extends Identifier<KEY>, DAO extends EntityDao<KEY, MODEL>> {

    EntityService<KEY,MODEL,DAO> entityService;

    public ExtentServicePropertyMethod(EntityService<KEY, MODEL, DAO> entityService) {
        this.entityService = entityService;
    }
    //<editor-fold desc="change property by keys">

    public void subPropertyMinValue(KEY id, String field, Object delta, Object minValue) {
        subPropertyMinValueByModel(entityService.getByIdOrNew(id), field, delta, minValue);

    }

    public void increasePropertyMinMaxValue(KEY id, String field, Object delta, Object minValue, Object maxValue) {
        increasePropertyMinMaxValueByModel(entityService.getByIdOrNew(id), field, delta, minValue, maxValue);

    }

    public void increaseMutiModelPropertyMinMaxValue(List<KEY> ids, String field, Object delta, Object minValue, Object maxValue) {
        increaseMutiModelPropertyMinMaxValueByModel(entityService.findByIdsOrNew(ids), field, delta, minValue, maxValue);

    }

    public void addMutiModelPropertyValue(List<KEY> ids, String field, Object delta) {
        addMutiModelPropertyValueByModel(entityService.findByIdsOrNew(ids), field, delta);

    }

    public void addPropertyValue(KEY id, String field, Object delta) {
        addPropertyValueByModel(entityService.getByIdOrNew(id), field, delta);

    }

    public void increaseMutiModelPropertyValues(List<KEY> ids, Object delta, String... fields) {
        increaseMutiModelPropertyValuesByModel(entityService.findByIdsOrNew(ids), delta, fields);

    }

    public void increaseMutiModelPropertyMinMaxValues(List<KEY> ids, Object delta, Object minValue, Object maxValue, String... fields) {
        increaseMutiModelPropertyMinMaxValuesByModel(entityService.findByIdsOrNew(ids), delta, minValue, maxValue, fields);

    }


    public void subMutiModelPropertyValues(List<KEY> ids, String... fields) {
        subMutiModelPropertyValuesByModel(entityService.findByIdsOrNew(ids), fields);

    }

    public void addPropertyMaxValues(KEY id, Object maxValue, String... fields) {
        addPropertyMaxValuesByModel(entityService.getByIdOrNew(id), maxValue, fields);

    }

    public void subPropertyValues(KEY id, Object delta, String... fields) {
        subPropertyValuesByModel(entityService.getByIdOrNew(id), delta, fields);

    }

    public void subPropertyMinValue(KEY id, String field, Object minValue) {
        subPropertyMinValueByModel(entityService.getByIdOrNew(id), field, minValue);

    }

    public void increasePropertyMinMaxValues(KEY id, Object delta, Object minValue, Object maxValue, String... fields) {
        increasePropertyMinMaxValuesByModel(entityService.getByIdOrNew(id), delta, minValue, maxValue, fields);

    }

    public void addMutiModelPropertyValues(List<KEY> ids, Object delta, String... fields) {
        addMutiModelPropertyValuesByModel(entityService.findByIdsOrNew(ids), delta, fields);

    }

    public void addPropertyValues(KEY id, Object delta, String... fields) {
        addPropertyValuesByModel(entityService.getByIdOrNew(id), delta, fields);

    }

    public void addPropertyMaxValue(KEY id, String field, Object delta, Object maxValue) {
        addPropertyMaxValueByModel(entityService.getByIdOrNew(id), field, delta, maxValue);

    }

    public void subMutiModelPropertyMinValues(List<KEY> ids, Object delta, Object minValue, String... fields) {
        subMutiModelPropertyMinValuesByModel(entityService.findByIdsOrNew(ids), delta, minValue, fields);

    }

    public void addMutiModelPropertyMaxValue(List<KEY> ids, String field, Object delta, Object maxValue) {
        addMutiModelPropertyMaxValueByModel(entityService.findByIdsOrNew(ids), field, delta, maxValue);

    }

    public void setPropertyValue(KEY id, String field, Object value) {
        setPropertyValueByModel(entityService.getByIdOrNew(id), field, value);

    }

    public void increaseMutiModelPropertyValue(List<KEY> ids, String field, Object delta) {
        increaseMutiModelPropertyValueByModel(entityService.findByIdsOrNew(ids), field, delta);

    }

    public void subMutiModelPropertyValue(List<KEY> ids, String field, Object delta) {
        subMutiModelPropertyValueByModel(entityService.findByIdsOrNew(ids), field, delta);

    }

    public void subMutiModelPropertyMinValues(List<KEY> ids, Object minValue, String... fields) {
        subMutiModelPropertyMinValuesByModel(entityService.findByIdsOrNew(ids), minValue, fields);

    }

    public void subMutiModelPropertyMinValue(List<KEY> ids, String field, Object minValue) {
        subMutiModelPropertyMinValueByModel(entityService.findByIdsOrNew(ids), field, minValue);

    }

    public void addPropertyValues(KEY id, String... fields) {
        addPropertyValuesByModel(entityService.getByIdOrNew(id), fields);

    }

    public void addPropertyMaxValues(KEY id, Object delta, Object maxValue, String... fields) {
        addPropertyMaxValuesByModel(entityService.getByIdOrNew(id), delta, maxValue, fields);

    }

    public void subPropertyValue(KEY id, String field, Object delta) {
        subPropertyValueByModel(entityService.getByIdOrNew(id), field, delta);

    }

    public void subPropertyMinValues(KEY id, Object delta, Object minValue, String... fields) {
        subPropertyMinValuesByModel(entityService.getByIdOrNew(id), delta, minValue, fields);

    }

    public void addMutiModelPropertyMaxValues(List<KEY> ids, Object delta, Object maxValue, String... fields) {
        addMutiModelPropertyMaxValuesByModel(entityService.findByIdsOrNew(ids), delta, maxValue, fields);

    }

    public void increasePropertyValue(KEY id, String field, Object delta) {
        increasePropertyValueByModel(entityService.getByIdOrNew(id), field, delta);

    }

    public void addMutiModelPropertyValues(List<KEY> ids, String... fields) {
        addMutiModelPropertyValuesByModel(entityService.findByIdsOrNew(ids), fields);

    }


    public void addPropertyMaxValue(KEY id, String field, Object maxValue) {
        addPropertyMaxValueByModel(entityService.getByIdOrNew(id), field, maxValue);

    }

    public void subPropertyValues(KEY id, String... fields) {
        subPropertyValuesByModel(entityService.getByIdOrNew(id), fields);

    }

    public void increasePropertyValues(KEY id, Object delta, String... fields) {
        increasePropertyValuesByModel(entityService.getByIdOrNew(id), delta, fields);

    }

    public void addMutiModelPropertyMaxValue(List<KEY> ids, String field, Object maxValue) {
        addMutiModelPropertyMaxValueByModel(entityService.findByIdsOrNew(ids), field, maxValue);

    }

    public void addMutiModelPropertyMaxValues(List<KEY> ids, Object maxValue, String... fields) {
        addMutiModelPropertyMaxValuesByModel(entityService.findByIdsOrNew(ids), maxValue, fields);

    }

    public void subMutiModelPropertyValues(List<KEY> ids, Object delta, String... fields) {
        subMutiModelPropertyValuesByModel(entityService.findByIdsOrNew(ids), delta, fields);

    }

    public void subMutiModelPropertyMinValue(List<KEY> ids, String field, Object delta, Object minValue) {
        subMutiModelPropertyMinValueByModel(entityService.findByIdsOrNew(ids), field, delta, minValue);

    }

    public <T> T getPropertyValue(KEY id, String field) {
        return getPropertyValueByModel(entityService.getByIdOrNew(id), field);

    }

    public void subPropertyMaxValues(KEY id, Object minValue, String... fields) {
        subPropertyMaxValuesByModel(entityService.getByIdOrNew(id), minValue, fields);

    }
    //</editor-fold>

//<editor-fold desc="change property by models">


    public void subPropertyMinValueByModel(MODEL model, String field, Object delta, Object minValue) {
        PropertyUtils.subPropertyMinValue(model, field, delta, minValue);
        entityService.updateFields(model, field);
    }

    public void increasePropertyMinMaxValueByModel(MODEL model, String field, Object delta, Object minValue, Object maxValue) {
        PropertyUtils.increasePropertyMinMaxValue(model, field, delta, minValue, maxValue);
        entityService.updateFields(model, field);
    }

    public void increaseMutiModelPropertyMinMaxValueByModel(List<MODEL> models, String field, Object delta, Object minValue, Object maxValue) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValue(models, field, delta, minValue, maxValue);
        entityService.updateFeildsAll(models, field);
    }

    public void addMutiModelPropertyValueByModel(List<MODEL> models, String field, Object delta) {
        PropertyUtils.addMutiModelPropertyValue(models, field, delta);
        entityService.updateFeildsAll(models, field);
    }

    public void addPropertyValueByModel(MODEL model, String field, Object delta) {
        PropertyUtils.addPropertyValue(model, field, delta);
        entityService.updateFields(model, field);
    }

    public void increaseMutiModelPropertyValuesByModel(List<MODEL> models, Object delta, String... fields) {
        PropertyUtils.increaseMutiModelPropertyValues(models, delta, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void increaseMutiModelPropertyMinMaxValuesByModel(List<MODEL> models, Object delta, Object minValue, Object maxValue, String... fields) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValues(models, delta, minValue, maxValue, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void subMutiModelPropertyValuesByModel(List<MODEL> models, String... fields) {
        PropertyUtils.subMutiModelPropertyValues(models, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void addPropertyMaxValuesByModel(MODEL model, Object maxValue, String... fields) {
        PropertyUtils.addPropertyMaxValues(model, maxValue, fields);
        entityService.updateFields(model, fields);
    }

    public void subPropertyValuesByModel(MODEL model, Object delta, String... fields) {
        PropertyUtils.subPropertyValues(model, delta, fields);
        entityService.updateFields(model, fields);
    }


    public void subPropertyMinValueByModel(MODEL model, String field, Object minValue) {
        PropertyUtils.subPropertyMinValue(model, field, minValue);
        entityService.updateFields(model, field);
    }

    public void increasePropertyMinMaxValuesByModel(MODEL model, Object delta, Object minValue, Object maxValue, String... fields) {
        PropertyUtils.increasePropertyMinMaxValues(model, delta, minValue, maxValue, fields);
        entityService.updateFields(model, fields);
    }

    public void addMutiModelPropertyValuesByModel(List<MODEL> models, Object delta, String... fields) {
        PropertyUtils.addMutiModelPropertyValues(models, delta, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void addPropertyValuesByModel(MODEL model, Object delta, String... fields) {
        PropertyUtils.addPropertyValues(model, delta, fields);
        entityService.updateFields(model, fields);
    }

    public void addPropertyMaxValueByModel(MODEL model, String field, Object delta, Object maxValue) {
        PropertyUtils.addPropertyMaxValue(model, field, delta, maxValue);
        entityService.updateFields(model, field);
    }

    public void subMutiModelPropertyMinValuesByModel(List<MODEL> models, Object delta, Object minValue, String... fields) {
        PropertyUtils.subMutiModelPropertyMinValues(models, delta, minValue, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void addMutiModelPropertyMaxValueByModel(List<MODEL> models, String field, Object delta, Object maxValue) {
        PropertyUtils.addMutiModelPropertyMaxValue(models, field, delta, maxValue);
        entityService.updateFeildsAll(models, field);
    }

    public void setPropertyValueByModel(MODEL model, String field, Object value) {
        PropertyUtils.setPropertyValue(model, field, value);
        entityService.updateFields(model, field);
    }

    public void increaseMutiModelPropertyValueByModel(List<MODEL> models, String field, Object delta) {
        PropertyUtils.increaseMutiModelPropertyValue(models, field, delta);
        entityService.updateFeildsAll(models, field);
    }

    public void subMutiModelPropertyValueByModel(List<MODEL> models, String field, Object delta) {
        PropertyUtils.subMutiModelPropertyValue(models, field, delta);
        entityService.updateFeildsAll(models, field);
    }

    public void subMutiModelPropertyMinValuesByModel(List<MODEL> models, Object minValue, String... fields) {
        PropertyUtils.subMutiModelPropertyMinValues(models, minValue, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void subMutiModelPropertyMinValueByModel(List<MODEL> models, String field, Object minValue) {
        PropertyUtils.subMutiModelPropertyMinValue(models, field, minValue);
        entityService.updateFeildsAll(models, field);
    }

    public void addPropertyValuesByModel(MODEL model, String... fields) {
        PropertyUtils.addPropertyValues(model, fields);
        entityService.updateFields(model, fields);
    }

    public void addPropertyMaxValuesByModel(MODEL model, Object delta, Object maxValue, String... fields) {
        PropertyUtils.addPropertyMaxValues(model, delta, maxValue, fields);
        entityService.updateFields(model, fields);
    }

    public void subPropertyValueByModel(MODEL model, String field, Object delta) {
        PropertyUtils.subPropertyValue(model, field, delta);
        entityService.updateFields(model, field);
    }

    public void subPropertyMinValuesByModel(MODEL model, Object delta, Object minValue, String... fields) {
        PropertyUtils.subPropertyMinValues(model, delta, minValue, fields);
        entityService.updateFields(model, fields);
    }

    public void addMutiModelPropertyMaxValuesByModel(List<MODEL> models, Object delta, Object maxValue, String... fields) {
        PropertyUtils.addMutiModelPropertyMaxValues(models, delta, maxValue, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void increasePropertyValueByModel(MODEL model, String field, Object delta) {
        PropertyUtils.increasePropertyValue(model, field, delta);
        entityService.updateFields(model, field);
    }

    public void addMutiModelPropertyValuesByModel(List<MODEL> models, String... fields) {
        PropertyUtils.addMutiModelPropertyValues(models, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void addPropertyMaxValueByModel(MODEL model, String field, Object maxValue) {
        PropertyUtils.addPropertyMaxValue(model, field, maxValue);
        entityService.updateFields(model, field);
    }

    public void subPropertyValuesByModel(MODEL model, String... fields) {
        PropertyUtils.subPropertyValues(model, fields);
        entityService.updateFields(model, fields);
    }

    public void increasePropertyValuesByModel(MODEL model, Object delta, String... fields) {
        PropertyUtils.increasePropertyValues(model, delta, fields);
        entityService.updateFields(model, fields);
    }

    public void addMutiModelPropertyMaxValueByModel(List<MODEL> models, String field, Object maxValue) {
        PropertyUtils.addMutiModelPropertyMaxValue(models, field, maxValue);
        entityService.updateFeildsAll(models, field);
    }

    public void addMutiModelPropertyMaxValuesByModel(List<MODEL> models, Object maxValue, String... fields) {
        PropertyUtils.addMutiModelPropertyMaxValues(models, maxValue, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void subMutiModelPropertyValuesByModel(List<MODEL> models, Object delta, String... fields) {
        PropertyUtils.subMutiModelPropertyValues(models, delta, fields);
        entityService.updateFeildsAll(models, fields);
    }

    public void subMutiModelPropertyMinValueByModel(List<MODEL> models, String field, Object delta, Object minValue) {
        PropertyUtils.subMutiModelPropertyMinValue(models, field, delta, minValue);
        entityService.updateFeildsAll(models, field);
    }

    public <T> T getPropertyValueByModel(MODEL model, String field) {
        return PropertyUtils.getPropertyValue(model, field);
    }

    public void subPropertyMaxValuesByModel(MODEL model, Object minValue, String... fields) {
        PropertyUtils.subPropertyMaxValues(model, minValue, fields);
        entityService.updateFields(model, fields);
    }
    //</editor-fold>

}
