package org.jsmth.jorm.redis.jdbc;

import org.jsmth.domain.Identifier;
import org.springframework.data.redis.core.*;

import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 2015/3/12
 * Time: 20:40
 */
public class RedisJdbcDao<KEY extends Serializable,ID extends Serializable, MODEL extends Identifier<ID>> extends RedisTemplate<KEY, MODEL> {
    protected RedisDataSource redisDataSource;
    protected Class<MODEL> modelClass;
    protected Class<KEY> keyClass;
    protected Class<ID> idClass;

    public RedisJdbcDao(Class<KEY> keyClass, Class<ID> idClass, Class<MODEL> modelClass) {
        this.keyClass = keyClass;
        this.idClass = idClass;
        this.modelClass = modelClass;
    }

    public RedisDataSource getRedisDataSource() {
        return redisDataSource;
    }

    public void setRedisDataSource(RedisDataSource redisDataSource) {
        setRedisDataSource(redisDataSource,this.keyClass,this.idClass, this.modelClass);
    }

    public void setRedisDataSource(RedisDataSource redisDataSource, Class<KEY> keyClass, Class<ID> idClass, Class<MODEL> modelClass) {
//        this.redisDataSource = redisDataSource;
//        this.setConnectionFactory(redisDataSource.getConnectionFactory());
//        this.setKeySerializer(new Jackson2JsonRedisSerializer<KEY>(keyClass));
//        this.setValueSerializer(new Jackson2JsonRedisSerializer<MODEL>(modelClass));
//        this.setHashKeySerializer(this.getValueSerializer());
//        this.setHashValueSerializer(this.getValueSerializer());
//        this.afterPropertiesSet();
    }

    public KEY convertKey(ID id){
        return null;

    }
//
//
//    public void deleteId(ID id) {
//        super.delete(convertKey(id));
//    }
//
//
//    public void deleteIds(Collection<KEY> keys) {
//        super.delete(keys);
//    }
//
//
//    public Boolean hasId(KEY key) {
//        return super.hasKey(key);
//    }
//
//
//    public Boolean expireId(KEY key, long timeout, TimeUnit unit) {
//        return super.expire(key, timeout, unit);
//    }
//
//
//    public Boolean expireAtId(KEY key, Date date) {
//        return super.expireAt(key, date);
//    }
//
//
//    public Long getExpireId(KEY key) {
//        return super.getExpire(key);
//    }
//
//
//    public Long getExpireId(KEY key, TimeUnit timeUnit) {
//        return super.getExpire(key, timeUnit);
//    }
//
//
//    public Set<KEY> keyIds(KEY pattern) {
//        return super.keys(pattern);
//    }
//
//
//    public Boolean persistId(KEY key) {
//        return super.persist(key);
//    }
//
//
//    public Boolean moveId(KEY key, int dbIndex) {
//        return super.move(key, dbIndex);
//    }
//
//
//    public KEY randomKey() {
//        return super.randomKey();
//    }
//
//
//    public void renameId(KEY oldKey, KEY newKey) {
//        super.rename(oldKey, newKey);
//    }
//
//
//    public Boolean renameIfAbsentId(KEY oldKey, KEY newKey) {
//        return super.renameIfAbsent(oldKey, newKey);
//    }
//
//
//    public DataType typeId(KEY key) {
//        return super.type(key);
//    }
//
//
//    public byte[] dumpId(KEY key) {
//        return super.dump(key);
//    }
//
//
//    public void restoreId(KEY key, byte[] value, long timeToLive, TimeUnit unit) {
//        super.restore(key, value, timeToLive, unit);
//    }
//
//
//    public void watchId(KEY key) {
//        super.watch(key);
//    }
//
//
//    public void watchId(Collection<KEY> keys) {
//        super.watch(keys);
//    }
//
//
//    public List<MODEL> sortId(SortQuery<KEY> query) {
//        return super.sort(query);
//    }
//
//
//    public <T> List<T> sort(SortQuery<KEY> query, RedisSerializer<T> resultSerializer) {
//        return super.sort(query, resultSerializer);
//    }
//
//
//    public <T> List<T> sort(SortQuery<KEY> query, BulkMapper<T, MODEL> bulkMapper) {
//        return super.sort(query, bulkMapper);
//    }
//
//
//    public <T, S> List<T> sort(SortQuery<KEY> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
//        return super.sort(query, bulkMapper, resultSerializer);
//    }
//
//
//    public Long sort(SortQuery<KEY> query, KEY storeKey) {
//        return super.sort(query, storeKey);
//    }
//
//
//    public BoundValueOperations<KEY, MODEL> boundValueOps(KEY key) {
//        return super.boundValueOps(key);
//    }
//
//
//    public ValueOperations<KEY, MODEL> opsForValue() {
//        return super.opsForValue();
//    }
//
//
//    public ListOperations<KEY, MODEL> opsForList() {
//        return super.opsForList();
//    }
//
//
//    public BoundListOperations<KEY, MODEL> boundListOps(KEY key) {
//        return super.boundListOps(key);
//    }
//
//
//    public BoundSetOperations<KEY, MODEL> boundSetOps(KEY key) {
//        return super.boundSetOps(key);
//    }
//
//
//    public SetOperations<KEY, MODEL> opsForSet() {
//        return super.opsForSet();
//    }
//
//
//    public BoundZSetOperations<KEY, MODEL> boundZSetOps(KEY key) {
//        return super.boundZSetOps(key);
//    }
//
//
//    public ZSetOperations<KEY, MODEL> opsForZSet() {
//        return super.opsForZSet();
//    }
//
//
//    public <HK, HV> BoundHashOperations<KEY, HK, HV> boundHashOps(KEY key) {
//        return super.boundHashOps(key);
//    }
//
//
//    public <HK, HV> HashOperations<KEY, HK, HV> opsForHash() {
//        return super.opsForHash();
//    }

    //<editor-fold desc="key">
//
//    /**
//     * 删除给定的一个或多个 key 。不存在的 key 会被忽略。
//     * @param key
//     */
//    public void keydel(KEY key){
//        this.delete(key);
//    }
//
//    /**
//     * 序列化给定 key ，并返回被序列化的值，使用 RESTORE 命令可以将这个值反序列化为 Redis 键。
//     * @param key
//     */
//    public byte[] keydump(KEY key){
//        return this.dump(key);
//    }
//
//    /**
//     * 检查给定 key 是否存在。
//     * @param key
//     */
//    public boolean keyexists(KEY key){
//        return super.hasKey(key);
//    }
//
//    /**
//     * 为给定 key 设置生存时间，当 key 过期时(生存时间为 0 )，它会被自动删除。
//     * @param key
//     */
//    public boolean keyexpire(KEY key,long timeout, TimeUnit unit){
//        return super.expire(key,timeout, unit);
//    }
//
//    /**
//     * EXPIREAT 的作用和 EXPIRE 类似，都用于为 key 设置生存时间。不同在于 EXPIREAT 命令接受的时间参数是 UNIX 时间戳(unix timestamp)。
//     * @param key
//     * @param date ss
//     * @return 返回信息
//     */
//    public boolean keyexpireAt(KEY key,Date date){
//        return super.expireAt(key, date);
//    }
//
//    /**
//     * 查找所有符合给定模式 pattern 的 key 。
//     * KEYS * 匹配数据库中所有 key 。
//     * KEYS h?llo 匹配 hello ， hallo 和 hxllo 等。
//     * KEYS h*llo 匹配 hllo 和 heeeeello 等。
//     * KEYS h[ae]llo 匹配 hello 和 hallo ，但不匹配 hillo 。
//     * 特殊符号用 \ 隔开
//     * @param pattern
//     * @return 返回信息
//     */
//    public Set<KEY> keykeys(KEY pattern){
//        return super.keys(pattern);
//    }
//
//    /**
//     * 将 key 原子性地从当前实例传送到目标实例的指定数据库上，一旦传送成功， key 保证会出现在目标实例上，而当前实例上的 key 会被删除。
//     * @param key
//     */
//    public void keymigrate(KEY key){
//        throw new NotSupportedException("not support");
//    }
//
//    /**
//     * 将当前数据库的 key 移动到给定的数据库 db 当中。
//     * @param key
//     * @param dbIndex
//     * @return 返回信息
//     */
//    public boolean keymove(KEY key,int dbIndex){
//        return super.move(key,dbIndex);
//    }
//
//    /**
//     * OBJECT 命令允许从内部察看给定 key 的 Redis 对象。
//     * @param key
//     */
//    public void keyobject(KEY key){
//        throw new NotSupportedException("not support");
//    }
//
//    /**
//     * 移除给定 key 的生存时间，将这个 key 从『易失的』(带生存时间 key )转换成『持久的』(一个不带生存时间、永不过期的 key )。
//     * @param key
//     */
//    public boolean keypersist(KEY key){
//        return super.persist(key);
//    }
//
//    /**
//     * 这个命令和 EXPIRE 命令的作用类似，但是它以毫秒为单位设置 key 的生存时间，而不像 EXPIRE 命令那样，以秒为单位。
//     * @param key
//     */
//    public boolean keypexpire(KEY key,long timeout, TimeUnit unit){
//       return super.expire(key, timeout, unit);
//    }
//
//    /**
//     * 这个命令和 EXPIREAT 命令类似，但它以毫秒为单位设置 key 的过期 unix 时间戳，而不是像 EXPIREAT 那样，以秒为单位。
//     * @param key
//     * @param date ss
//     * @return 返回信息
//     */
//    public boolean keypexpireat(KEY key,Date date){
//        return expireAt(key, date);
//    }
//
//    /**
//     * 这个命令类似于 TTL 命令，但它以毫秒为单位返回 key 的剩余生存时间，而不是像 TTL 命令那样，以秒为单位。
//     * @param key
//     */
//    public long keypttl(KEY key){
//        throw new NotSupportedException("not support");
//    }
//
//    /**
//     * 从当前数据库中随机返回(不删除)一个 key 。
//     * @return 返回信息
//     */
//    public KEY keyrandomkey(){
//        return super.randomKey();
//    }
//
//    /**
//     *将 key 改名为 newkey 。
//     * @param key
//     */
//    public void keyrename(KEY key,KEY rekey){
//        super.rename(key,rekey);
//    }
//
//    /**
//     * 当且仅当 newkey 不存在时，将 key 改名为 newkey 。
//     * @param key
//     */
//    public boolean keyrenamenx(KEY key,KEY rekey){
//        return super.renameIfAbsent(key,rekey);
//    }
//
//    /**
//     * 反序列化给定的序列化值，并将它和给定的 key 关联。
//     * @param key
//     */
//    public void keyrestore(KEY key, byte[] value, long timeToLive, TimeUnit unit){
//        super.restore(key, value, timeToLive, unit);
//    }
//
//
//    public void keyttl(KEY key){
//    }
//
//    /**
//     * 返回 key 所储存的值的类型。
//     * @param key
//     */
//    public DataType keytype(KEY key){
//        return super.type(key);
//    }
//
//    /**
//     *
//     * @param key
//     */
//    public void keyscan(KEY key){
//        throw new NotSupportedException("not support");
//    }
    //</editor-fold>

    //<editor-fold desc="string">
//
//    /**
//     * 如果 key 已经存在并且是一个字符串， APPEND 命令将 value 追加到 key 原来的值的末尾。
//     * @param key
//     */
//    public int stringappend(KEY key,String value){
//        return super.opsForValue().append(key,value);
//    }
//
//    /**
//     * 计算给定字符串中，被设置为 1 的比特位的数量。
//     * @param key
//     */
//    public void stringbitcount(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringbitop(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringdecr(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringdecrby(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public MODEL stringget(KEY key){
//        return super.opsForValue().get(key);
//    }
//    public void stringgetbit(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public List<MODEL> stringgetrange(Collection<KEY> keys){
//        return super.opsForValue().multiGet(keys);
//    }
//    public void stringgetset(KEY key){
//        throw new NotSupportedException("not support");
//    }
//
//    /**
//     * 将 key 中储存的数字值增value。
//     * @param key
//     * @param value
//     */
//    public long stringincrby(KEY key,long value){
//        return super.opsForValue().increment(key,value);
//    }
//    public double stringincrby(KEY key,double value){
//        return super.opsForValue().increment(key,value);
//    }
//    public long stringincr(KEY key){
//        return stringincrby(key,1);
//    }
//    public float stringincrbyfloat(KEY key,float value){
//        return (float)stringincrby(key,value);
//    }
//    public void stringmget(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringmset(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringmsetnx(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringpsetex(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringset(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringsetbit(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringsetex(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringsetnx(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringsetrange(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void stringstrlen(KEY key){
//        throw new NotSupportedException("not support");
//    }
    //</editor-fold>

    //<editor-fold desc="hash">
//    public void hashhdel(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void hashhexists(KEY key){
//        throw new NotSupportedException("not support");
//    }
//    public void hashhget(KEY key){
//    }
//    public void hashhgetall(KEY key){
//    }
//    public void hashhincrby(KEY key){
//    }
//    public void hashhincrbyfloat(KEY key){
//    }
//    public void hashhkeys(KEY key){
//    }
//    public void hashhlen(KEY key){
//    }
//    public void hashhmget(KEY key){
//    }
//    public void hashhmset(KEY key){
//    }
//    public void hashhset(KEY key){
//    }
//    public void hashhsetnx(KEY key){
//    }
//    public void hashhvals(KEY key){
//    }
//    public void hashhscan(KEY key){
//    }
    //</editor-fold>

    //<editor-fold desc="list">
//    public MODEL listblpop(KEY key){
//        return this.opsForList().leftPop(key);
//    }
//    public MODEL listbrpop(KEY key){
//        return this.opsForList().rightPop(key);
//    }
//    public MODEL listbrpoplpush(KEY key,KEY key1){
//        return this.opsForList().rightPopAndLeftPush(key,key1);
//    }
//    public MODEL listlindex(KEY key,long index){
//        return this.opsForList().index(key,index);
//    }
//    public long listlinsert(KEY key,MODEL model){
//        return this.opsForList().leftPush(key,model);
//    }
//    public long listllen(KEY key){
//        return this.opsForList().size(key);
//    }
//    public MODEL listlpop(KEY key){
//        return this.opsForList().leftPop(key);
//    }
//    public long listlpush(KEY key,MODEL model){
//        return this.opsForList().leftPush(key,model);
//    }
//    public void listlpushx(KEY key){
//        //return this.opsForList().leftPush(key);
//    }
//    public void listlrange(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listlrem(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listlset(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listltrim(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listrpop(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listrpoplpush(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listrpush(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
//    public void listrpushx(KEY key){
//        //return this.opsForList().leftPop(key);
//    }
    //</editor-fold>

    //<editor-fold desc="set">
//    public void setsadd(KEY key){
//    }
//    public void setscard(KEY key){
//    }
//    public void setsdiff(KEY key){
//    }
//    public void setsdiffstore(KEY key){
//    }
//    public void setsinter(KEY key){
//    }
//    public void setsinterstore(KEY key){
//    }
//    public void setsismember(KEY key){
//    }
//    public void setsmembers(KEY key){
//    }
//    public void setsmove(KEY key){
//    }
//    public void setspop(KEY key){
//    }
//    public void setsrandmember(KEY key){
//    }
//    public void setsrem(KEY key){
//    }
//    public void setsunion(KEY key){
//    }
//    public void setsunionstore(KEY key){
//    }
//    public void setsscan(KEY key){
//    }
    //</editor-fold>

    //<editor-fold desc="sortedset">
//    public void sortedsetzadd(KEY key){
//    }
//    public void sortedsetzcard(KEY key){
//    }
//    public void sortedsetzcount(KEY key){
//    }
//    public void sortedsetzincrby(KEY key){
//    }
//    public void sortedsetzrange(KEY key){
//    }
//    public void sortedsetzrangebyscore(KEY key){
//    }
//    public void sortedsetzrank(KEY key){
//    }
//    public void sortedsetzrem(KEY key){
//    }
//    public void sortedsetzremrangebyrank(KEY key){
//    }
//    public void sortedsetzremrangebyscore(KEY key){
//    }
//    public void sortedsetzrevrange(KEY key){
//    }
//    public void sortedsetzrevrangebyscore(KEY key){
//    }
//    public void sortedsetzrevrank(KEY key){
//    }
//    public void sortedsetzscore(KEY key){
//    }
//    public void sortedsetzunionstore(KEY key){
//    }
//    public void sortedsetzinterstore(KEY key){
//    }
//    public void sortedsetzscan(KEY key){
//    }
//    public void sortedsetzrangebylex(KEY key){
//    }
//    public void sortedsetzlexcount(KEY key){
//    }
//    public void sortedsetzremrangebylex(KEY key){
//    }
    //</editor-fold>

    //<editor-fold desc="hyperloglog">
//    public void hyperloglogpfadd(KEY key){
//    }
//    public void hyperloglogpfcount(KEY key){
//    }
//    public void hyperloglogpfmerge(KEY key){
//    }
    //</editor-fold>

    //<editor-fold desc="pub/sub">
//    public void psubscribe(KEY key){
//    }
//    public void publish(KEY key){
//    }
//    public void pubsub(KEY key){
//    }
//    public void punsubscribe(KEY key){
//    }
//    public void subscribe(KEY key){
//    }
//    public void unsubscribe(KEY key){
//    }
    //</editor-fold>

    //<editor-fold desc="transaction">
//    public void discard(KEY key){
//    }
//    public void exec(KEY key){
//    }
//    public void multi(KEY key){
//    }
//    public void unwatch(KEY key){
//    }
//    public void watch(KEY key){
//    }
    //</editor-fold>


//    /**
//     * 压栈
//     *
//     * @param key
//     * @param value
//     * @return 返回信息
//     */
//    public Long push(KEY key, MODEL value) {
//        return super.opsForList().leftPush(key, value);
//    }
//
//    /**
//     * 出栈
//     *
//     * @param key
//     * @return 返回信息
//     */
//    public MODEL pop(KEY key) {
//        return super.opsForList().leftPop(key);
//    }
//
//
//    /**
//     * 栈/队列长
//     *
//     * @param key
//     * @return 返回信息
//     */
//    public Long length(KEY key) {
//        return super.opsForList().size(key);
//    }
//
//    /**
//     * 范围检索
//     *
//     * @param key
//     * @param start
//     * @param end
//     * @return 返回信息
//     */
//    public List<MODEL> range(KEY key, int start, int end) {
//        return super.opsForList().range(key, start, end);
//    }
//
//    /**
//     * 移除
//     *
//     * @param key
//     * @param i
//     * @param value
//     */
//    public void remove(KEY key, long i, MODEL value) {
//        super.opsForList().remove(key, i, value);
//    }
//
//    /**
//     * 检索
//     *
//     * @param key
//     * @param index
//     * @return 返回信息
//     */
//    public MODEL index(KEY key, long index) {
//        return super.opsForList().index(key, index);
//    }
//
//    /**
//     * 置值
//     *
//     * @param key
//     * @param index
//     * @param value
//     */
//    public void set(KEY key, long index, MODEL value) {
//        super.opsForList().set(key, index, value);
//    }
//
//    /**
//     * 裁剪
//     *
//     * @param key
//     * @param start
//     * @param end
//     */
//    public void trim(KEY key, long start, int end) {
//        super.opsForList().trim(key, start, end);
//    }
//
//    //<editor-fold desc="queue">
//
//    /**
//     * 入队
//     * 增加一个元索                     如果队列已满，则抛出一个IIIegaISlabEepeplian异常
//     *
//     * @param key
//     * @param value
//     * @return 返回信息
//     */
//    public Long addQueue(KEY key, MODEL value) {
//        return super.opsForList().rightPush(key, value);
//    }
//
//    /**
//     * 出队
//     * 移除并返问队列头部的元素    如果队列为空，则返回null
//     *
//     * @param key
//     * @return 返回信息
//     */
//    public MODEL removeQueue(KEY key) {
//        if (sizeQueue(key) == 0)
//            return null;
//        return super.opsForList().leftPop(key);
//    }
//
//    /**
//     * 返回队列头部的元素             如果队列为空，则抛出一个NoSuchElementException
//     */
//    public MODEL firstQueue(KEY key) {
//        if (sizeQueue(key) == 0)
//            return null;
//        return super.opsForList().index(key, 0);
//    }
//
//    /**
//     * 添加一个元素并返回true       如果队列已满，则返回false
//     *
//     * @param key
//     * @param value
//     */
//    public boolean offerQueue(KEY key, MODEL value) {
//        addQueue(key, value);
//        return true;
//    }
//
//    /**
//     * 移除并返问队列头部的元素    如果队列为空，则返回null
//     *
//     * @param key
//     */
//    public MODEL pollQueue(KEY key) {
//        return firstQueue(key);
//    }
//
//
//    /**
//     * 返回队列头部的元素             如果队列为空，则返回null
//     *
//     * @param key
//     */
//    public MODEL peekQueue(KEY key) {
//        return firstQueue(key);
//    }
//
//    /**
//     * 添加一个元素                      如果队列满，则阻塞
//     *
//     * @param key
//     */
//    public long putQueue(KEY key, MODEL value) {
//        return addQueue(key, value);
//    }
//
//    /**
//     * 移除并返回队列头部的元素     如果队列为空，则阻塞
//     *
//     * @param key
//     */
//    public MODEL takeQueue(KEY key) {
//        return removeQueue(key);
//    }
//
//    public long sizeQueue(KEY key) {
//        return super.opsForList().size(key);
//    }
//
//    public boolean emptyQueue(KEY key) {
//        return sizeQueue(key) == 0;
//    }
//    //</editor-fold>
}
