package org.jsmth.jorm.redis.daoservice;

import org.jsmth.domain.Identifier;
import org.jsmth.jorm.redis.dao.RedisReadWriteEntityDao;
import org.jsmth.jorm.redis.jdbc.RedisDataSource;
import org.jsmth.jorm.redis.service.RedisReadWriteEntityService;

import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 2015/3/12
 * Time: 21:04
 */
public class RedisReadWriteEntityDaoService<KEY extends Serializable, MODEL extends Identifier<KEY>>
        extends RedisReadWriteEntityService<KEY, MODEL, RedisReadWriteEntityDao<KEY, MODEL>> {


    public RedisReadWriteEntityDaoService(Class<KEY> keyClass, Class<MODEL> modelClass) {
        this.entityDao = new RedisReadWriteEntityDao<KEY, MODEL>(keyClass, modelClass);
    }

    public RedisDataSource getRedisDataSource() {
        return entityDao.getRedisDataSource();
    }

    public void setRedisDataSource(RedisDataSource redisDataSource) {
        entityDao.setRedisDataSource(redisDataSource);
    }
}
