package org.jsmth.jorm.redis.daoservice;

import org.jsmth.domain.Identifier;
import org.jsmth.jorm.redis.dao.RedisEntityDao;
import org.jsmth.jorm.redis.jdbc.RedisDataSource;
import org.jsmth.jorm.redis.service.RedisEntityService;

import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 2015/3/12
 * Time: 21:04
 */
public class RedisEntityDaoService<KEY extends Serializable, MODEL extends Identifier<KEY>>
        extends RedisEntityService<KEY, MODEL, RedisEntityDao<KEY, MODEL>> {
    public RedisEntityDaoService(Class<KEY> keyClass, Class<MODEL> modelClass) {
        this.entityDao = new RedisEntityDao<KEY, MODEL>(keyClass, modelClass);
    }

    public RedisDataSource getRedisDataSource() {
        return entityDao.getRedisDataSource();
    }

    public void setRedisDataSource(RedisDataSource redisDataSource) {
        entityDao.setRedisDataSource(redisDataSource);
    }
}
