package org.jsmth.jorm.redis.dao;

import org.jsmth.domain.Identifier;
import org.jsmth.jorm.redis.jdbc.RedisDataSource;
import org.jsmth.jorm.redis.jdbc.RedisIdJdbcDao;

import java.io.Serializable;

/**
 * MODEL: 马生录（mason
 * Date: 2015/3/12
 * Time: 21:04
 */
public class RedisReadWriteEntityDao<KEY extends Serializable, MODEL extends Identifier<KEY>> extends RedisEntityDao<KEY, MODEL> {
    protected RedisDataSource redisSlaveDataSource;
    protected RedisIdJdbcDao<KEY, MODEL> jdbcSlaveDao;

    public RedisReadWriteEntityDao(Class<KEY> keyClass, Class<MODEL> modelClass) {
        super(keyClass, modelClass);
    }

    public RedisDataSource getRedisSlaveDataSource() {
        return redisSlaveDataSource;
    }

    public void setRedisSlaveDataSource(RedisDataSource redisSlaveDataSource) {
        this.redisSlaveDataSource = redisSlaveDataSource;
        if (jdbcSlaveDao == null) {
            jdbcSlaveDao = new RedisIdJdbcDao<KEY, MODEL>(keyClass, modelClass);
        }
        jdbcSlaveDao.setRedisDataSource(redisDataSource,keyClass,keyClass,modelClass);
    }

    public RedisIdJdbcDao<KEY, MODEL> getJdbcMasterDao() {
        return jdbcDao;
    }

    public void setJdbcMasterDao(RedisIdJdbcDao<KEY, MODEL> jdbcMasterDao) {
        this.jdbcDao = jdbcMasterDao;
    }

    public RedisIdJdbcDao<KEY, MODEL> getJdbcSlaveDao() {
        return jdbcSlaveDao;
    }

    public void setJdbcSlaveDao(RedisIdJdbcDao<KEY, MODEL> jdbcSlaveDao) {
        this.jdbcSlaveDao = jdbcSlaveDao;
    }
}
