package org.jsmth.jorm.query.where;

import org.jsmth.jorm.query.other.WhereClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class NotEqualClause extends WhereClause {

    String columnName;
    Object value;

    public NotEqualClause(String columnName, Object value) {
        this(AND, columnName, value);
    }

    public NotEqualClause(int logic, String columnName, Object value) {
        super(logic);
        this.columnName = columnName;
        this.value = value;
    }

    public <T extends Enum> NotEqualClause(String columnName, Enum value, boolean ordinal) {
        this(AND, columnName, value, ordinal);
    }

    public <T extends Enum> NotEqualClause(int logic, String columnName, Enum value, boolean ordinal) {
        super(logic);
        this.columnName = columnName;
        if (ordinal) {
            this.value = value.ordinal();
        } else {
            this.value = value.name();
        }
    }

    @Override
    public String getSql() {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" <> ?");
        return where.toString();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        params.add(value);
        return params;
    }

}
