package org.jsmth.jorm.query.where;

import org.jsmth.jorm.query.other.WhereClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class LikeClause extends WhereClause {

    public static final String FIX_TAG = "%";
    String columnName;
    String keyword;
    boolean before;
    boolean after;


    public LikeClause(String columnName, String keyword) {
        this(columnName, keyword, false, true);
    }

    public LikeClause(String columnName, String keyword, boolean after) {
        this(columnName, keyword, false, after);
    }

    public LikeClause(String columnName, String keyword, boolean before, boolean after) {
        this(AND, columnName, keyword, before, after);
    }

    public LikeClause(int logic, String columnName, String keyword) {
        this(logic, columnName, keyword, false, true);
    }

    public LikeClause(int logic, String columnName, String keyword, boolean after) {
        this(logic, columnName, keyword, false, after);
    }

    public LikeClause(int logic, String columnName, String keyword, boolean before, boolean after) {
        super(logic);
        this.columnName = columnName;
        this.keyword = keyword;
        this.before = before;
        this.after = after;
    }

    @Override
    public String getSql() {
        if (!before && !after) {
            throw new IllegalArgumentException("befor and after value is both false.");
        }
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" like '");
        if (before) {
            where.append(FIX_TAG);
        }
        where.append("?");
        if (after) {
            where.append(FIX_TAG);
        }
        where.append("' ");
        return where.toString();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        params.add(keyword);
        return params;
    }

}
