package org.jsmth.jorm.query.where;

import org.jsmth.jorm.query.other.WhereClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class LessThanClause extends WhereClause {

    String columnName;
    Object value;
    boolean equal;

    public LessThanClause(String columnName, Object value) {
        this(AND, columnName, value);
    }
    public LessThanClause(String columnName, Object value, boolean equal) {
        this(AND, columnName, value,equal);
    }

    public LessThanClause(int logic, String columnName, Object value) {
        this(AND, columnName, value,false);
    }

    public LessThanClause(int logic, String columnName, Object value, boolean equal) {
        super(logic);
        this.columnName = columnName;
        this.value = value;
        this.equal = equal;
    }

    @Override
       public String getSql() {
        StringBuilder where = new StringBuilder();
                where.append(columnName);
                if(equal){
                    where.append(" <= ?");
                }else{
                    where.append(" < ?");
                }
           return where.toString();
       }

       @Override
       public List sqlParams() {
           List params = new LinkedList();
           params.add(value);
           return params;
       }

}
