package org.jsmth.jorm.query.where;

import org.apache.commons.lang.ArrayUtils;
import org.jsmth.jorm.query.other.WhereClause;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class InClause extends WhereClause {

    String columnName;
    List values;

    public InClause(int logic, String columnName, Object... values) {
        super(logic);
        this.values = new LinkedList();
        addWhere(columnName, values);
    }

    public InClause(String columnName, Object... values) {
        this(AND, columnName, values);
    }

    public void addWhere(String columnName, Object... values) {
        if (ArrayUtils.isEmpty(values)) {
            throw new IllegalArgumentException("values is empty,");
        }
        if (values.length == 1) {
            Collection items = new LinkedList();
            Object item = values[0];
            if (item instanceof Collection) {
                items.addAll((Collection) item);
            } else {
                items.add(item);
            }
            addWhere(columnName, items);
        } else
            addWhere(columnName, Arrays.asList(values));
    }

    public void addWhere(String columnName, Collection values) {
        this.columnName = columnName;
        this.values.addAll(values);
    }


    @Override
    public String getSql() {
        StringBuilder where = new StringBuilder();
        where.append(columnName);
        where.append(" in (");
        StringBuilder in = new StringBuilder();
        for (Object value : values) {
            if (in.length() > 0) {
                in.append(",");
            }
            in.append("?");
        }
        where.append(in.toString());
        where.append(") ");
        return where.toString();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        for (Object value : values) {
            params.add(value);
        }
        return params;
    }
}
