package org.jsmth.jorm.query.where;

import org.jsmth.jorm.query.other.WhereClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class BetweenThanClause extends WhereClause {

    String columnName;
    Object beginValue;
    boolean beginEqual;
    Object endValue;
    boolean endEqual;

    public BetweenThanClause(String columnName, Object beginValue, Object endValue) {
        this(AND, columnName, beginValue, true, endValue, true);
    }

    public BetweenThanClause(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        this(AND, columnName, beginValue, beginEqual, endValue, endEqual);
    }

    public BetweenThanClause(int logic, String columnName, Object beginValue, Object endValue) {
        this(logic, columnName, beginValue, true, endValue, true);
    }

    public BetweenThanClause(int logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        super(logic);
        this.columnName = columnName;
        this.beginValue = beginValue;
        this.beginEqual = beginEqual;
        this.endValue = endValue;
        this.endEqual = endEqual;
    }

    @Override
    public String getSql() {
        StringBuilder where = new StringBuilder();
        MoreThanClause moreThanClause = new MoreThanClause(columnName, beginValue, beginEqual);
        LessThanClause lessThanClause = new LessThanClause(columnName, endValue, endEqual);
        where.append(moreThanClause.toString());
        where.append(" AND ");
        where.append(lessThanClause.toString());
        return where.toString();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        MoreThanClause moreThanClause = new MoreThanClause(columnName, beginValue, beginEqual);
        LessThanClause lessThanClause = new LessThanClause(columnName, endValue, endEqual);
        params.addAll(moreThanClause.sqlParams());
        params.addAll(lessThanClause.sqlParams());
        return params;
    }

    @Override
    public String toString() {
        return getSql();
    }
}
