package org.jsmth.jorm.query.select;

import org.jsmth.jorm.query.other.SelectClause;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 下午12:03
 */
public class GroupMethodClause extends SelectClause {
    public static final int SUM = 1;
    public static final int COUNT = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;

    int method;

    public GroupMethodClause(String columnName, int method) {
        this(columnName, method, "");
    }

    public GroupMethodClause(String columnName, int method, String aliasName) {
        super(columnName, aliasName);
        this.method = method;
    }

    @Override
    public String toString() {
        StringBuilder sql = new StringBuilder();
        switch (method){
            case SUM:
                sql.append(" SUM");
                break;
            case COUNT:
                sql.append(" COUNT");
                break;
            case MIN:
                sql.append(" MIN");
                break;
            case MAX:
                sql.append(" MAX");
                break;
            default:
                throw new IllegalArgumentException("method is fail.");
        }
        sql.append("(");
        sql.append(columnName);
        sql.append(")");
        if (aliasName != null && !"".equals(aliasName)) {
            sql.append(" AS ");
            sql.append(aliasName);
        }
        return sql.toString();
    }
}
