package org.jsmth.jorm.query.other;

import org.jsmth.jorm.query.Clause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:28
 */
public class SelectClause extends Clause {

    public static final int DEFAULT = 0;
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int LEN = 5;
    public static final int AVG = 6;
    public static final int FIRST = 7;
    public static final int LAST = 8;
    public static final int TEAM = 9;
    public static final int ALL = 10;


    public final static String ALL_TAG = "*";

    public final static SelectClause ALL_SELECT = new SelectClause(ALL_TAG, "", ALL);

    protected String columnName = "";
    protected String aliasName = "";
    int groupMethod;

    public SelectClause(String columnName, String aliasName, int groupMethod) {
        this.columnName = columnName;
        this.aliasName = aliasName;
        this.groupMethod = groupMethod;
    }

    public SelectClause(String columnName, String aliasName) {
        this(columnName, aliasName, DEFAULT);
    }

    public SelectClause(String columnName) {
        this(columnName, "");
    }


    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        switch (groupMethod) {
            case COUNT:
                sql.append("count(");
                break;
            case SUM:
                sql.append("sum(");
                break;
            case MIN:
                sql.append("min(");
                break;
            case MAX:
                sql.append("max(");
                break;
            case AVG:
                sql.append("avg(");
                break;
            case ALL:
                sql.append("count(");
                break;
            case DEFAULT:
                sql.append("");
                break;
            default:
                throw new IllegalArgumentException("group method not support.");
        }
        sql.append(columnName);
        if (groupMethod != DEFAULT) {
            sql.append(")");
        }
        if (aliasName != null && !"".equals(aliasName)) {
            sql.append(" as ");
            sql.append(aliasName);
        }
        return sql.toString();
    }

    @Override
    public List sqlParams() {
        return new LinkedList();
    }

    @Override
    public String toString() {
        return getSql();
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getAliasName() {
        return aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public int getGroupMethod() {
        return groupMethod;
    }

    public void setGroupMethod(int groupMethod) {
        this.groupMethod = groupMethod;
    }
}
