package org.jsmth.jorm.query.other;

import org.jsmth.jorm.query.Clause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:28
 */
public class OrderClause extends Clause {
    public static final int DEFAULT = 1;
    public static final int ASC = 2;
    public static final int DASC = 3;
    String columnName;
    int style = DEFAULT;

    public OrderClause(String columnName) {
        this(columnName, DEFAULT);
    }

    public OrderClause(String columnName, int style) {
        this.columnName = columnName;
        this.style = style;
    }

    @Override
    public String getSql() {
        switch (style) {
            case DEFAULT:
                return columnName;
            case ASC:
                return columnName + " asc";
            case DASC:
                return columnName + " desc";
        }
        return columnName;
    }

    @Override
    public List sqlParams() {
        return new LinkedList();
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getStyle() {
        return style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}
