package org.jsmth.jorm.query.other;

import org.jsmth.jorm.query.Clause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:28
 */
public class LimitClause extends Clause {
    public static final int DEFAULT_PAGESIZE = 10;

    int pageNumber;
    int pageSize;

    public LimitClause() {
        this(1);
    }

    public LimitClause(int pageNumber) {
        this(pageNumber, DEFAULT_PAGESIZE);
    }

    public LimitClause(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }


    @Override
    public String getSql() {
        return (this.pageNumber-1)*this.pageSize + " , " + this.pageSize;
    }

    @Override
    public List sqlParams() {
        return new LinkedList();
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
