package org.jsmth.jorm.query.other;

import org.jsmth.jorm.query.Clause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:28
 */
public class InsertClause extends Clause {

    protected String columnName = "";
    protected Object value = "";

    public InsertClause(String columnName, Object value) {
        this.columnName = columnName;
        this.value = value;
    }


    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" ? ");
        return sql.toString();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        params.add(value);
        return params;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}
