package org.jsmth.jorm.query.clause.where;

import org.apache.commons.lang.StringUtils;
import org.jsmth.jorm.query.clause.CommonConjuctClause;

import java.util.List;

/**
 *
 *    name like 'xxx'
 *    name like '%xxx'
 *    name like 'xxx%'
 *    name like '%xxx%'
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class LikeClause extends CommonConjuctClause {

    String columnName;
    String prefix;
    String postfix;

    public LikeClause(String columnName, String prefix) {
        this.columnName = columnName;
        this.prefix = prefix;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        like(sql, sqlParams, columnName, prefix);
    }

    @Override
    protected boolean isNull() {
        return StringUtils.isBlank(prefix);
    }
}
