package org.jsmth.jorm.query.clause.where;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.jsmth.jorm.query.clause.CommonConjuctClause;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class InClause extends CommonConjuctClause {

    String columnName;
    List values;

    public InClause(String columnName, Object... values) {
        this.columnName = columnName;
        if (ArrayUtils.isEmpty(values)) {
            this.values = Collections.emptyList();
        } else {
            this.values = Arrays.asList(values);
        }
    }

    public InClause(String columnName, List values) {
        this.columnName = columnName;
        this.values = values;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        in(sql, sqlParams, columnName, values);
    }

    @Override
    protected boolean isNull() {
        return CollectionUtils.isEmpty(values);
    }
}
