package org.jsmth.jorm.query.clause.where;

import org.jsmth.jorm.query.clause.CommonConjuctClause;

import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class BetweenClause extends CommonConjuctClause {

    String columnName;
    Object start;
    boolean startIncludeEquals;
    Object end;
    boolean endIncludeEquals;

    public BetweenClause(String columnName, Object start, Object end) {
        this(columnName, start, true, end, true);
    }

    public BetweenClause(String columnName, Object start, boolean startIncludeEquals, Object end, boolean endIncludeEquals) {
        this.columnName = columnName;
        this.start = start;
        this.startIncludeEquals = startIncludeEquals;
        this.end = end;
        this.endIncludeEquals = endIncludeEquals;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        between(sql, sqlParams, columnName, start, startIncludeEquals, end, endIncludeEquals);
    }

    @Override
    protected boolean isNull() {
        return start == null && end == null;
    }
}
