package org.jsmth.jorm.query.clause;

import org.jsmth.jorm.query.clause.EmptyConjuctClause;

import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class PagingClause extends EmptyConjuctClause {

    Integer pageNumber;
    Integer pageSize;

    public PagingClause(Integer pageNumber, Integer pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        if (pageNumber != null && pageSize != null) {
            if (pageSize < 0) pageSize = 0;
            if (pageNumber < 1) pageNumber = 1;
            sql.append("limit ").append(((pageNumber - 1) * pageSize)).append(',').append(pageSize);
        }
    }

    @Override
    protected boolean isNull() {
        return pageNumber == null || pageSize == null;
    }
}
