package org.jsmth.jorm.query.clause;

import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:33:09
 */
@SuppressWarnings({"unchecked"})
public class OrderClause extends EmptyConjuctClause {

    String columnName1;
    Boolean asc1 = null;
    String columnName2;
    Boolean asc2 = null;

    public OrderClause(String columnName, Boolean asc) {
        this.columnName1 = columnName;
        this.asc1 = asc;
    }

    public OrderClause(String columnName1, Boolean asc1, String columnName2, Boolean asc2) {
        this.columnName1 = columnName1;
        this.asc1 = asc1;
        this.columnName2 = columnName2;
        this.asc2 = asc2;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        if (!StringUtils.isEmpty(columnName1) && asc1 != null)
            sql.append("order by ").append(columnName1).append(asc1 ? " asc" : " desc");
        else
            return;

        if (!StringUtils.isEmpty(columnName2) && asc2 != null)
            sql.append(", ").append(columnName2).append(asc2 ? " asc" : " desc");
    }

    @Override
    protected boolean isNull() {
        return StringUtils.isEmpty(columnName1) || asc1 == null;
    }
}
