package org.jsmth.jorm.query.clause;


import org.jsmth.domain.Identifier;
import org.jsmth.jorm.service.EntityDao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 查询where语句的封装
 * 举例子
 * Query q = new Query();
 * q.append(new LikeClause("id" , businessId));
 * q.append(new EnumEqualClause FileType ("fileType" , fileType));
 * q.append(new BetweenClause("postDate",startDay, endDay));
 * q.append(new OrderClause("postDate",orderByPostDateAsc, "fileSize",orderByFileSizeAsc));
 * q.append(new PagingClause(pageNumber, pageSize));
 * 构造出来的sql语句是
 * User: mason
 * Date: 2010-6-24
 * Time: 10:02:40
 */
@SuppressWarnings({"unchecked"})
public class OldQuery {

    public static final String SQL_TRUE = "1=1";
    public static final String SQL_FALSE = "1<>1";
    public static final int AND=1;
    public static final int OR=2;
    public static final int NOT=3;

    protected StringBuilder sql = new StringBuilder();
    protected List param = new ArrayList(3);
    protected boolean empty = true;

    public OldQuery() {
    }

    public OldQuery(OldClause clause) {
        append(clause);
    }

    public OldQuery(OldQuery query, int logic) {
        append(query);
    }

    /**
     * 默认以and关系加上一个子query
     *
     * @param query d
     * @return 返回信息
     */
    public OldQuery append(OldQuery query) {
        return append(query, AND);
    }

    public OldQuery append(OldQuery query,int logic ) {
        if (!empty) {
            switch(logic){
                case AND:
                    sql.append(" and ");
                    break;
                case OR:
                    sql.append(" or ");
                    break;
                case NOT:
                    sql.append(" not ");
                    break;
            }
        }

        sql.append('(');
        sql.append(query.sql);
        sql.append(')');
        param.addAll(query.param);
        empty = false;
        return this;
    }

    /**
     * 默认以and关系加上一个clause
     *
     * @param clause d
     * @return 返回信息
     */
    public OldQuery append(OldClause clause) {
        return append(clause, AND);
    }

    public OldQuery append(OldClause clause, int logic) {
        clause.prepare(sql, param);
        if (!empty) {
            clause.append(logic);
        } else {
            clause.execute();
        }
        empty = false;
        return this;
    }

    public String getSql() {
        return sql.toString();
    }

    public List getParam() {
        return param;
    }

    public Object[] getParameters() {
        return param.toArray();
    }

    @Override
    public String toString() {
        return String.format("Query SQL[%s] params%s", sql.toString(), param);
    }

    public <KEY extends Serializable, MODEL extends Identifier<KEY>> List<KEY> findIds(EntityDao<KEY, MODEL> dao) {
        return dao.findIds(this.getSql(), this.getParameters());
    }

    public <KEY extends Serializable, MODEL extends Identifier<KEY>> List<MODEL> findModels(EntityDao<KEY, MODEL> dao) {
        return dao.findModels(this.getSql(), this.getParameters());
    }
}
