package org.jsmth.jorm.query.clause;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * sql查询子句
 * User: mason
 * Date: 2010-6-24
 * Time: 11:05:19
 */
@SuppressWarnings({"unchecked"})
public abstract class OldClause {

    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;

    protected StringBuilder sql;
    protected List sqlParams;

    protected abstract boolean isNull();

    /**
     * clause每次被操作之前，必须先调用prepare方法
     *
     * @param sql d
     * @param sqlParams d
     */
    public void prepare(StringBuilder sql, List sqlParams) {
        this.sql = sql;
        this.sqlParams = sqlParams;
    }

    public abstract void append(int logic);

    public abstract void execute(StringBuilder sql, List sqlParams);

    public void execute() {
        this.execute(sql, sqlParams);
    }

    public String expression() {
        StringBuilder sb = new StringBuilder();
        this.execute(sb, new ArrayList());
        return sb.toString();
    }

    //static methods

    public static void equal(StringBuilder sql, List sqlParams, String columnName, Object prop) {
        if (prop != null) {
            sql.append(columnName).append("=?");
            sqlParams.add(prop);
        }
    }

    public static <T extends Enum> void equal(StringBuilder sql, List sqlParams, String columnName, T prop, boolean useName) {
        if (prop != null) {
            sql.append(columnName).append("=?");
            if (useName) {
                sqlParams.add(prop.name());
            } else {
                sqlParams.add(prop.ordinal());
            }
        }
    }

    public static void like(StringBuilder sql, List sqlParams, String columnName, String prefix) {
        if (!StringUtils.isBlank(prefix)) {
            sql.append(columnName).append(" like '?%'");
            sqlParams.add(prefix);
        }
    }

    public static void between(StringBuilder sql, List sqlParams, String columnName, Object start, Object end) {
        between(sql, sqlParams, columnName, start, true, end, true);
    }

    @SuppressWarnings({"ConstantConditions"})
    public static void between(StringBuilder sql, List sqlParams, String columnName, Object start, boolean startIncludeEquals, Object end, boolean endIncludeEquals) {
        if (start != null && end != null) {
            if (start.equals(end)) {
                sql.append(columnName).append("=?");
                sqlParams.add(start);

            } else {
                sql.append('(');
                sql.append(columnName).append(">");
                if (startIncludeEquals)
                    sql.append("=");
                sql.append("? and ").append(columnName).append("<");
                if (endIncludeEquals)
                    sql.append("=");
                sql.append("?");
                sql.append(')');
                sqlParams.add(start);
                sqlParams.add(end);
            }
        } else if (start != null && end == null) {
            sql.append(columnName).append(">");
            if (startIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(start);

        } else if (start == null && end != null) {
            sql.append(columnName).append("<");
            if (endIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(end);
        } else {
        }
    }

    public static void in(StringBuilder sql, List sqlParams, String columnName, List values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }

        sql.append(columnName).append(" in(");
        for (Object value : values) {
            if (value != null) {
                sql.append("?,");
                sqlParams.add(value);
            }
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
    }

    public static void in(StringBuilder sql, List sqlParams, String columnName, Object... values) {
        if (ArrayUtils.isEmpty(values)) {
            return;
        }

        sql.append(columnName).append(" in(");
        for (Object value : values) {
            if (value != null) {
                sql.append("?,");
                sqlParams.add(value);
            }
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
    }

    public static void order(StringBuilder sql, List sqlParams, String columnName, boolean asc) {
        order(sql, sqlParams, columnName, asc, null, false);
    }

    public static void order(StringBuilder sql, List sqlParams, String columnName1, boolean asc1, String columnName2, boolean asc2) {
        if (!StringUtils.isEmpty(columnName1))
            sql.append("order by ").append(columnName1).append(asc1 ? " asc " : " desc ");
        if (!StringUtils.isEmpty(columnName2))
            sql.append(",").append(columnName2).append(asc2 ? " asc " : " desc ");
    }

    public static void paging(StringBuilder sql, List sqlParams, int pageNumber, int pageSize) {
        if (pageSize < 0) pageSize = 0;
        if (pageNumber < 1) pageNumber = 1;
        sql.append(" limit ").append(((pageNumber - 1) * pageSize)).append(',').append(pageSize);
    }

}
