package org.jsmth.jorm.query.clause;

import java.util.List;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:24:30
 */
@SuppressWarnings({"unchecked"})
public class EnumEqualClause<T extends Enum>  extends CommonConjuctClause {

    String columnName;
    T prop;
    boolean useName = true;

    public EnumEqualClause(String columnName, T prop) {
        this.columnName = columnName;
        this.prop = prop;
        this.useName = true;
    }

    public EnumEqualClause(String columnName, T prop, boolean useName) {
        this.columnName = columnName;
        this.prop = prop;
        this.useName = useName;
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        equal(sql, sqlParams, columnName, prop, useName);
    }

    @Override
    protected boolean isNull() {
        return prop == null;
    }
}
