package org.jsmth.jorm.query.clause;

import org.jsmth.jorm.service.EntityDao;

import java.util.ArrayList;
import java.util.List;

/**
 * User: mason
 * Date: 2010-7-20
 * Time: 11:27:32
 */
public class CountableQuery extends OldQuery {

    protected StringBuilder countSql = new StringBuilder();
    protected List countParam = new ArrayList(3);

    public CountableQuery() {
    }

    @Override
    public OldQuery append(OldQuery query, int logic) {
        if (!empty) {
            switch (logic) {
                case AND:
                    sql.append(" and ");
                    countSql.append(" and ");
                    break;
                case OR:
                    sql.append(" or ");
                    countSql.append(" or ");
                    break;
                case NOT:
                    sql.append(" not ");
                    countSql.append(" not ");
                    break;
            }
        }

//        sql.append('(');
//        sql.append(query.sql);
//        sql.append(')');
//
//        countSql.append('(');
//        countSql.append(query.sql);
//        countSql.append(')');
//
//        param.addAll(query.param);
//        countParam.addAll(query.param);

        empty = false;
        return this;
    }

    @Override
    public OldQuery append(OldClause clause, int logic) {
        if ((clause instanceof OrderClause) || (clause instanceof PagingClause)) {
            //do nothing
            clause.prepare(sql, param);
            if (!empty) {
                clause.append(logic);
            } else {
                clause.execute();
            }

        } else {
            clause.prepare(sql, param);
            if (!empty) {
                clause.append(logic);
            } else {
                clause.execute();
            }

            clause.prepare(countSql, countParam);
            if (!empty) {
                clause.append(logic);
            } else {
                clause.execute();
            }

            empty = false;
        }
        return this;
    }

    //gs

    public String getQuerySql() {
        return super.getSql();
    }

    public List getQueryParam() {
        return super.getParam();
    }

    public Object[] getQueryParameters() {
        return super.getParam().toArray();
    }

    public String getCountSql() {
        return countSql.toString();
    }

    public List getCountParam() {
        return countParam;
    }

    public Object[] getCountParameters() {
        return countParam.toArray();
    }

    public int count(EntityDao dao) {
        return dao.countModels(this.getCountSql(), this.getCountParameters());
    }

}
