package org.jsmth.jorm.query.clause;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * User: mason
 * Date: 2010-6-24
 * Time: 11:33:09
 */
@SuppressWarnings({"unchecked"})
public class ComplexOrderByClause extends EmptyConjuctClause {

    Collection<Map.Entry<String, Boolean>> columns;


    public ComplexOrderByClause(Map.Entry<String, Boolean>... columns) {
        this.columns = Arrays.asList(columns);
    }

    public ComplexOrderByClause(Collection<Map.Entry<String, Boolean>> columns) {
        this.columns = columns;
    }

    public ComplexOrderByClause(Map<String, Boolean> columns) {
        this.columns = columns.entrySet();
    }

    @Override
    public void execute(StringBuilder sql, List sqlParams) {
        if (columns != null && !columns.isEmpty()) {
            sql.append("order by ");
            for (Map.Entry<String, Boolean> entry : columns) {
                String key = entry.getKey();
                Boolean val = entry.getValue();
                if (StringUtils.isBlank(key) || val == null)
                    continue;
                sql.append(key).append(val ? " asc" : " desc");
            }
        }
    }

    @Override
    protected boolean isNull() {
        return columns == null || columns.isEmpty();
    }
}
