package org.jsmth.jorm.query;

import org.jsmth.jorm.query.other.LimitClause;
import org.jsmth.jorm.query.other.OrderClause;
import org.jsmth.jorm.query.other.WhereClause;
import org.jsmth.jorm.query.where.*;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:55
 */
public class WhereQuery extends Query {

    StringBuilder whereSql;
    StringBuilder orderSql;
    List whereParams;
    int pageNumber = 0;
    int pageSize = 0;

    public WhereQuery() {
        whereSql = new StringBuilder();
        orderSql = new StringBuilder();
        whereParams = new LinkedList();
    }


    public WhereQuery where(WhereClause clause) {
        return where(clause, false);
    }

    public WhereQuery order(String columnName) {
        OrderClause clause = new OrderClause(columnName);
        return order(clause);
    }

    public WhereQuery order(String columnName, int style) {
        OrderClause clause = new OrderClause(columnName, style);
        return order(clause);
    }

    public WhereQuery order(OrderClause clause) {
        if (orderSql.length() > 0) {
            orderSql.append(" , ");
        }
        orderSql.append(clause.getSql());
        return this;
    }

    public WhereQuery whereLike(int logic, String columnName, String keyword) {
        LikeClause clause = new LikeClause(logic, columnName, keyword);
        return where(clause);
    }

    public WhereQuery whereLike(String columnName, String keyword) {
        LikeClause clause = new LikeClause(columnName, keyword);
        return where(clause);
    }

    public WhereQuery whereLike(int logic, String columnName, String keyword, boolean after) {
        LikeClause clause = new LikeClause(logic, columnName, keyword, after);
        return where(clause);
    }

    public WhereQuery whereLike(String columnName, String keyword, boolean after) {
        LikeClause clause = new LikeClause(columnName, keyword, after);
        return where(clause);
    }

    public WhereQuery whereLike(int logic, String columnName, String keyword, boolean before, boolean after) {
        LikeClause clause = new LikeClause(logic, columnName, keyword, before, after);
        return where(clause);
    }

    public WhereQuery whereLike(String columnName, String keyword, boolean before, boolean after) {
        LikeClause clause = new LikeClause(columnName, keyword, before, after);
        return where(clause);
    }

    public WhereQuery whereLessThan(int logic, String columnName, Object value) {
        LessThanClause clause = new LessThanClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereLessThan(String columnName, Object value) {
        LessThanClause clause = new LessThanClause(columnName, value);
        return where(clause);
    }

    public WhereQuery whereLessThan(int logic, String columnName, Object value, boolean equal) {
        LessThanClause clause = new LessThanClause(logic, columnName, value, equal);
        return where(clause);
    }

    public WhereQuery whereLessThan(String columnName, Object value, boolean equal) {
        LessThanClause clause = new LessThanClause(columnName, value, equal);
        return where(clause);
    }

    public WhereQuery whereMoreThan(int logic, String columnName, Object value) {
        MoreThanClause clause = new MoreThanClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereMoreThan(String columnName, Object value) {
        MoreThanClause clause = new MoreThanClause(columnName, value);
        return where(clause);
    }

    public WhereQuery whereMoreThan(int logic, String columnName, Object value, boolean equal) {
        MoreThanClause clause = new MoreThanClause(logic, columnName, value, equal);
        return where(clause);
    }

    public WhereQuery whereMoreThan(String columnName, Object value, boolean equal) {
        MoreThanClause clause = new MoreThanClause(columnName, value, equal);
        return where(clause);
    }

    public WhereQuery whereIn(int logic, String columnName, Object value) {
        InClause clause = new InClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereIn(String columnName, Object value) {
        InClause clause = new InClause(columnName, value);
        return where(clause);
    }


    public WhereQuery whereNotIn(int logic, String columnName, Object value) {
        NotInClause clause = new NotInClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereNotIn(String columnName, Object value) {
        NotInClause clause = new NotInClause(columnName, value);
        return where(clause);
    }

    public WhereQuery whereNotEqual(int logic, String columnName, Object value) {
        NotEqualClause clause = new NotEqualClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereNotEqual(String columnName, Object value) {
        NotEqualClause clause = new NotEqualClause(columnName, value);
        return where(clause);
    }

    public <ENUM extends Enum> WhereQuery whereNotEqual(String columnName, ENUM value, boolean ordinal) {
        NotEqualClause clause = new NotEqualClause(columnName, value, ordinal);
        return where(clause);
    }

    public <ENUM extends Enum> WhereQuery whereNotEqual(int logic, String columnName, ENUM value, boolean ordinal) {
        NotEqualClause clause = new NotEqualClause(logic, columnName, value, ordinal);
        return where(clause);
    }

    public WhereQuery whereEqual(int logic, String columnName, Object value) {
        EqualClause clause = new EqualClause(logic, columnName, value);
        return where(clause);
    }

    public WhereQuery whereEqual(String columnName, Object value) {
        EqualClause clause = new EqualClause(columnName, value);
        return where(clause);
    }

    public <ENUM extends Enum> WhereQuery whereEqual(String columnName, ENUM value, boolean ordinal) {
        EqualClause clause = new EqualClause(columnName, value, ordinal);
        return where(clause);
    }

    public <ENUM extends Enum> WhereQuery whereEqual(int logic, String columnName, ENUM value, boolean ordinal) {
        EqualClause clause = new EqualClause(logic, columnName, value, ordinal);
        return where(clause);
    }

    public WhereQuery whereBetweenThan(int logic, String columnName, Object beginValue, Object endValue) {
        BetweenThanClause clause = new BetweenThanClause(logic, columnName, beginValue, endValue);
        return where(clause);
    }

    public WhereQuery whereBetweenThan(String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanClause clause = new BetweenThanClause(columnName, beginValue, beginEqual, endValue, endEqual);
        return where(clause);
    }

    public WhereQuery whereBetweenThan(int logic, String columnName, Object beginValue, boolean beginEqual, Object endValue, boolean endEqual) {
        BetweenThanClause clause = new BetweenThanClause(logic, columnName, beginValue, beginEqual, endValue, endEqual);
        return where(clause);
    }

    public WhereQuery where(WhereClause clause, boolean prePackage) {
        if (whereSql.length() > 0) {
            if (prePackage) {
                whereSql.insert(0, "( ");
                whereSql.append(" ) ");
            }
            switch (clause.getLogic()) {
                case WhereClause.AND:
                    whereSql.append(" and ");
                    break;
                case WhereClause.OR:
                    whereSql.append(" or ");
                    break;
                case WhereClause.NOT:
                    whereSql.append(" not ");
                    break;
            }
        }
        whereSql.append(clause.getSql());
        whereParams.addAll(clause.sqlParams());
        return this;
    }

    public WhereQuery limit(LimitClause clause) {
        pageNumber = clause.getPageNumber();
        pageSize = clause.getPageSize();
        return this;
    }

    public WhereQuery limit(int pageNumber, int pageSize) {
        LimitClause clause = new LimitClause(pageNumber, pageSize);
        return limit(clause);
    }

    @Override
    public String getSql() {
        return getSql(true);
    }
    public String getSql(boolean includeLimit) {
        return getSql(true,includeLimit);
    }

    public String getSql(boolean includeOrder,boolean includeLimit) {
        StringBuffer sql = new StringBuffer();
        if (whereSql.length() > 0)
            sql.append(getWhereSql());
        if (includeOrder && orderSql.length() > 0)
            sql.append(" order by " + getOrderSql());
        if (includeLimit && pageNumber > 0) {
            sql.append(" limit " + getLimitSql());
        }
        return sql.toString();
    }

    public String getNoLimitSql() {
        StringBuffer sql = new StringBuffer();

        return sql.toString();
    }


    public String getWhereSql() {
        return whereSql.toString();
    }

    public String getOrderSql() {
        return orderSql.toString();
    }

    public String getLimitSql() {
        LimitClause clause = new LimitClause(pageNumber, pageSize);
        return clause.getSql();
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        params.addAll(whereParams);
        return params;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
