package org.jsmth.jorm.query;

import org.jsmth.jorm.query.other.UpdateClause;
import org.jsmth.jorm.query.other.WhereClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:09
 */
public class UpdateQuery extends Query {

    StringBuilder updateSql;
    StringBuilder whereSql;
    List updateParams;
    List whereParams;
    String tableName;


    public UpdateQuery() {
        updateSql = new StringBuilder();
        whereSql = new StringBuilder();
        tableName = "";
        updateParams = new LinkedList();
        whereParams = new LinkedList();
    }

    public UpdateQuery field(UpdateClause clause) {
        if (updateSql.length() > 0) {
            updateSql.append(" , ");
        }
        updateSql.append(clause.toString());
        updateParams.addAll(clause.sqlParams());
        return this;
    }

    public UpdateQuery where(WhereClause clause) {
        return where(clause, false);
    }

    public UpdateQuery where(WhereClause clause, boolean prePackage) {
        if (whereSql.length() > 0) {
            if (prePackage) {
                whereSql.insert(0, "( ");
                whereSql.append(" ) ");
            }
            switch (clause.getLogic()) {
                case WhereClause.AND:
                    whereSql.append(" and ");
                    break;
                case WhereClause.OR:
                    whereSql.append(" or ");
                    break;
                case WhereClause.NOT:
                    whereSql.append(" not ");
                    break;
            }
        }
        whereSql.append(clause.toString());
        whereParams.addAll(clause.sqlParams());
        return this;
    }

    public UpdateQuery where(WhereQuery query) {
        whereSql = new StringBuilder();
        whereSql.append(query.toString());
        whereParams.add(query.sqlParams());
        return this;
    }

    @Override
    public List sqlParams() {
        List params = new LinkedList();
        params.addAll(updateParams);
        params.addAll(whereParams);
        return params;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("update ");
        sql.append(getTableName());
        sql.append(" set ");
        sql.append(getUpdateSql());
        if (whereSql.length() > 0) {
            sql.append(" where ");
            sql.append(getWhereSql());
        }
        return sql.toString();
    }

    public String getUpdateSql() {
        return updateSql.toString();
    }

    public String getWhereSql() {
        return whereSql.toString();
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List getUpdateParams() {
        return updateParams;
    }

    public void setUpdateParams(List updateParams) {
        this.updateParams = updateParams;
    }


}
