package org.jsmth.jorm.query;

import org.jsmth.jorm.query.other.*;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-26
 * Time: 下午7:36
 */
public class SqlQuery extends WhereQuery {

    String tableName;
    StringBuilder groupSql;
    StringBuilder selectSql;
    List<SelectClause> selectClauses;

    public SqlQuery() {
        selectSql = new StringBuilder();
        groupSql = new StringBuilder();
        selectClauses = new LinkedList<SelectClause>();
        tableName = "";
    }

    @Override
    public SqlQuery where(WhereClause clause) {
        super.where(clause);
        return this;
    }

    @Override
    public SqlQuery order(String columnName) {
        super.order(columnName);
        return this;
    }

    @Override
    public SqlQuery order(OrderClause clause) {
        super.order(clause);
        return this;
    }

    @Override
    public SqlQuery limit(LimitClause clause) {
        super.limit(clause);
        return this;
    }

    public SqlQuery select(String columnName, String aliasName, int groupMethod) {
        SelectClause clause = new SelectClause(columnName, aliasName, groupMethod);
        return select(clause);
    }

    public SqlQuery select(String columnName, String aliasName) {
        SelectClause clause = new SelectClause(columnName, aliasName);
        return select(clause);
    }

    public SqlQuery select(SelectClause clause) {
        if (selectSql.length() > 0) {
            selectSql.append(" , ");
        }
        selectClauses.add(clause);
        selectSql.append(clause.getSql());
        return this;
    }

    public SqlQuery group(String columnName) {
        GroupClause clause = new GroupClause(columnName);
        return group(clause);
    }

    public SqlQuery group(GroupClause clause) {
        if (groupSql.length() > 0) {
            groupSql.append(" , ");
        }
        groupSql.append(clause.getSql());
        return this;
    }

    public String getSelectSql() {
        StringBuffer sql = new StringBuffer();
        for (SelectClause clause : selectClauses) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(clause.getSql());
        }
        return sql.toString();
    }

    public String getGroupSql() {
        StringBuffer sql = new StringBuffer();
        for (SelectClause clause : selectClauses) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(clause.getColumnName());
        }
        return sql.toString();
    }

    @Override
    public String getSql() {
        return getSql(true);
    }

    public String getSql(boolean includeLimit) {
        return getSql(true,true, includeLimit);
    }

    public String getSql(boolean includeOrder,boolean includeGroup, boolean includeLimit) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select " + getSelectSql());
        sql.append(" from " + getTableName());
        if (whereSql.length() > 0)
            sql.append(" where " + getWhereSql());
        if (includeOrder && orderSql.length() > 0)
            sql.append(" order by " + getOrderSql());
        if (includeGroup && groupSql.length() > 0) {
            sql.append(" group by " + getGroupSql());
        }
        if (includeLimit && pageNumber > 0) {
            sql.append(" limit " + getLimitSql());
        }
        return sql.toString();
    }

    public String getLimitSql() {
        StringBuffer sql = new StringBuffer();

        int number = this.getPageNumber();
        if(number<=0)
            number=1;
        sql.append(number);
        sql.append(",");
        int size = this.getPageSize();
        if(size<=0){
            size=0;
        }
        sql.append(size);
        return sql.toString();
    }

    public String getWhereSql() {
        return whereSql.toString();
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setGroupSql(StringBuilder groupSql) {
        this.groupSql = groupSql;
    }

    public List<SelectClause> getSelectClauses() {
        return selectClauses;
    }

    public void setSelectClauses(List<SelectClause> selectClauses) {
        this.selectClauses = selectClauses;
    }
}
