package org.jsmth.jorm.query;

import org.jsmth.jorm.query.other.InsertClause;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-12-25
 * Time: 上午10:09
 */
public class InsertQuery extends Query {

    StringBuilder fieldSql;
    StringBuilder valueSql;
    List insertParams;
    String tableName;


    public InsertQuery() {
        fieldSql = new StringBuilder();
        valueSql=new StringBuilder();
        tableName = "";
        insertParams = new LinkedList();
    }

    public InsertQuery insert(InsertClause clause) {
        if (fieldSql.length() > 0) {
            fieldSql.append(" , ");
        }
        fieldSql.append(clause.getColumnName());
        if (valueSql.length() > 0) {
            valueSql.append(" , ");
        }
        valueSql.append(clause.toString());
        insertParams.addAll(clause.sqlParams());
        return this;
    }

    @Override
    public List sqlParams() {
        return insertParams;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("insert ");
        sql.append(getTableName());
        sql.append(" ( ");
        sql.append(getFieldSql());
        sql.append(" ) ");
        sql.append(" values( ");
        sql.append(getValueSql());
        sql.append(" ) ");
        return sql.toString();
    }

    public String getFieldSql() {
        return fieldSql.toString();
    }

    public String getValueSql() {
        return valueSql.toString();
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List getInsertParams() {
        return insertParams;
    }

    public void setInsertParams(List insertParams) {
        this.insertParams = insertParams;
    }


}
