package org.jsmth.jorm.modelservice;

import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.service.CommonEntityDao;
import org.jsmth.jorm.service.CommonReadWriteEntityDao;
import org.springframework.util.Assert;

import javax.annotation.PostConstruct;
import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 13-1-18
 * Time: 下午1:28
 * please use ReadWriteEntityDaoService
 */
@Deprecated
 public abstract class ReadWriteEntityModelService<KEY extends Serializable, MODEL extends Identifier<KEY>> extends EntityModelService<KEY, MODEL> {
    protected JdbcDao masterJdbcDao;
    protected JdbcDao slaveJdbcDao;

    public ReadWriteEntityModelService(Class<MODEL> entityClass) {
        super(entityClass);
    }


    @PostConstruct
    @Override
    public void init() {
        super.init();
        Assert.notNull(getMasterJdbcDao(), "masterJdbcDao must be set!");
        Assert.notNull(getSlaveJdbcDao(), "slaveJdbcDao must be set!");
        CommonReadWriteEntityDao<KEY, MODEL> entityDao = new CommonReadWriteEntityDao<KEY, MODEL>(entityClass);
        entityDao.setMasterDao(getMasterJdbcDao());
        entityDao.setSlaveJdbcDao(getSlaveJdbcDao());
        entityDaoClass = CommonEntityDao.class;
        this.setEntityDao(entityDao);
    }


    @Override
    public void setJdbcDao(JdbcDao jdbcDao) {
        super.setJdbcDao(jdbcDao);
        this.masterJdbcDao = jdbcDao;
    }

    public JdbcDao getMasterJdbcDao() {
        return masterJdbcDao;
    }

    public void setMasterJdbcDao(JdbcDao masterJdbcDao) {
        this.masterJdbcDao = masterJdbcDao;
        this.jdbcDao = masterJdbcDao;
    }

    public JdbcDao getSlaveJdbcDao() {
        return slaveJdbcDao;
    }

    public void setSlaveJdbcDao(JdbcDao slaveJdbcDao) {
        this.slaveJdbcDao = slaveJdbcDao;
    }
}
