package org.jsmth.jorm.modelservice;

import org.jsmth.cache.Cache;
import org.jsmth.cache.CacheService;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.jorm.action.FindAllAction;
import org.jsmth.jorm.action.QueryAction;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.JdbcDao;
import org.jsmth.jorm.service.EntityCacheHelper;
import org.jsmth.jorm.service.ReadWriteEntityDao;
import org.jsmth.page.Page;
import org.jsmth.page.RollPage;
import org.jsmth.page.TailPage;
import org.springframework.util.Assert;

import javax.annotation.PostConstruct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-1-18
 * Time: 下午1:28
 * please use EntityCacheableDaoService
 */
@Deprecated
public abstract class EntityCacheableModelService<KEY extends Serializable, MODEL extends Identifier<KEY>> extends EntityModelService<KEY, MODEL> {
    protected boolean useReadWriteEntityDao = false;
    protected boolean useCache = true;
    protected CacheService cacheService;
    protected int entityCacheMaxSize = 1000;
    protected int entityCacheMaxLiveSeconds = 3600;

    protected Cache entityCache;

    public EntityCacheableModelService(Class<MODEL> entityClass) {
        super(entityClass);
    }

    @PostConstruct
    @Override
    public void init() {
        super.init();
        Assert.notNull(cacheService, "cacheService must be set!");
        getEntityCache();
        useReadWriteEntityDao = (entityDao instanceof ReadWriteEntityDao);
    }

    protected Cache getEntityCache() {
        if (entityCache == null) {
            entityCache = cacheService.addCache(this.getClass().getName(), entityCacheMaxSize, entityCacheMaxLiveSeconds);
        }
        return entityCache;
    }

    @Override
    public MODEL getById(KEY id) {
        return getById(id, true);
    }

    public MODEL getById(KEY id, boolean useMasterExplicit) {
        if (useMasterExplicit)
            return EntityCacheHelper.getById(useCache, entityCacheMaxLiveSeconds, entityClass, entityDao.getJdbcDao(), getEntityCache(), id);
        else
            return EntityCacheHelper.getById(useCache, entityCacheMaxLiveSeconds, entityClass, ((ReadWriteEntityDao) entityDao).getSlaveJdbcDao(), getEntityCache(), id);
    }

    @Override
    public MODEL getOrCreateById(KEY id) {
        MODEL model = EntityCacheHelper.getById(useCache, entityCacheMaxLiveSeconds, entityClass, jdbcDao, getEntityCache(), id);
        if (model == null) {
            try {
                model = entityDao.getEntityClass().newInstance();
                model.setIdentifier(id);
                this.insert(model);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return model;
    }

    @Override
    public List<MODEL> findByIds(List<KEY> ids) {
        return findByIds(ids, !useReadWriteEntityDao);
    }

    public List<MODEL> findByIds(List<KEY> ids, boolean useMasterExplicit) {
        if (useMasterExplicit)
            return EntityCacheHelper.findByIds(useCache, entityCacheMaxLiveSeconds, entityClass, jdbcDao, getEntityCache(), ids);
        else
            return EntityCacheHelper.findByIds(useCache, entityCacheMaxLiveSeconds, entityClass, ((ReadWriteEntityDao) entityDao).getSlaveJdbcDao(), getEntityCache(), ids);
    }

    @Override
    public MODEL insert(MODEL entity) {
        return entityDao.insert(entity);
    }

    @Override
    public void insertAll(Collection<MODEL> entities) {
        entityDao.insertAll(entities);
    }

    @Override
    public int update(MODEL entity) {
        int ret = entityDao.update(entity);
        //实体缓存更新
        if (useCache) {
            EntityCacheHelper.onEntityUpdate(entityCacheMaxLiveSeconds, getEntityCache(), entity);
        }
        return ret;
    }


    @Override
    public int updateFields(MODEL entity, String... fieldNames) throws SmthDataAccessException {
        int ret = entityDao.updateFields(entity, fieldNames);
        //实体缓存更新
        if (useCache) {
            EntityCacheHelper.onEntityUpdate(entityCacheMaxLiveSeconds, getEntityCache(), entity);
        }
        return ret;
    }

    @Override
    public int updateAll(Collection<MODEL> entities) {
        int ret = entityDao.updateAll(entities);
        //实体缓存批量更新
        if (useCache) {
            EntityCacheHelper.onEntityUpdate(entityCacheMaxLiveSeconds, getEntityCache(), entities.toArray(new Identifier[entities.size()]));
        }
        return ret;
    }


    @Override
    public int updateFeildsAll(Collection<MODEL> entities, String... fieldNames) throws SmthDataAccessException {
        int ret = entityDao.updateFeildsAll(entities, fieldNames);
        //实体缓存批量更新
        if (useCache) {
            EntityCacheHelper.onEntityUpdate(entityCacheMaxLiveSeconds, getEntityCache(), entities.toArray(new Identifier[entities.size()]));
        }
        return ret;
    }

    @Override
    public MODEL save(MODEL entity) {
        int ret = this.update(entity);
        if (ret == 0) {
            this.insert(entity);
        }
        return entity;
    }

    @Override
    public boolean delete(MODEL entity) {
        boolean ret = entityDao.delete(entity);
        EntityCacheHelper.onEntityDelete(getEntityCache(), entity);
        return ret;
    }

    @Override
    public int deleteAll(Collection<MODEL> entities) {
        int ret = entityDao.deleteAll(entities);
        EntityCacheHelper.onEntityDelete(getEntityCache(), entities.toArray(new Identifier[entities.size()]));
        return ret;
    }

    // find all methods

    public Page<KEY> findAllIds(boolean asc, int pageNumber, int pageSize) {
        return new RollPage<KEY>(pageNumber, pageSize, new ArrayList<KEY>(getFindAllCacheAction(asc, pageNumber, pageSize).getIds()));
    }

    public Page<MODEL> findAll(boolean asc, int pageNumber, int pageSize) {
        return getFindAllCacheAction(asc, pageNumber, pageSize).getPage();
    }

    public TailPage<MODEL> findAllTail(boolean asc, int pageNumber, int pageSize) {
        return getFindAllCacheAction(asc, pageNumber, pageSize).getTailPage();
    }

    @SuppressWarnings({"unchecked"})
    protected FindAllAction<KEY, MODEL> getFindAllCacheAction(boolean asc, int pageNumber, int pageSize) {
        return (FindAllAction<KEY, MODEL>) buildQueryAction(FindAllAction.class, asc, pageNumber, pageSize);
    }

    public boolean isUseCache() {
        return useCache;
    }

    public CacheService getCacheService() {
        return cacheService;
    }

    public int getEntityCacheMaxSize() {
        return entityCacheMaxSize;
    }

    public int getEntityCacheMaxLiveSeconds() {
        return entityCacheMaxLiveSeconds;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setEntityCacheMaxSize(int entityCacheMaxSize) {
        this.entityCacheMaxSize = entityCacheMaxSize;
    }

    public void setEntityCacheMaxLiveSeconds(int entityCacheMaxLiveSeconds) {
        this.entityCacheMaxLiveSeconds = entityCacheMaxLiveSeconds;
    }

    protected <ACTION extends QueryAction<KEY, MODEL>> ACTION buildQueryAction(Class<ACTION> clazz, Object... params) {
        ACTION action;
        try {
            action = clazz.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("CacheAction class[" + clazz + "] must be public and contains a default Constructor", e);
        }
        if (useReadWriteEntityDao) {
            action.prepare(getClass().getName(), isUseCache(), getEntityDao().getEntityClass(), ((ReadWriteEntityDao) getEntityDao()).getSlaveJdbcDao(), getEntityCache(), params);
        } else {
            action.prepare(getClass().getName(), isUseCache(), getEntityDao().getEntityClass(), getEntityDao().getJdbcDao(), getEntityCache(), params);
        }
        return action;
    }

    public boolean isUseReadWriteEntityDao() {
        return useReadWriteEntityDao;
    }

    public void setUseReadWriteEntityDao(boolean useReadWriteEntityDao) {
        this.useReadWriteEntityDao = useReadWriteEntityDao;
    }

    public void setJdbcDao(JdbcDao jdbcDao) {
        this.jdbcDao = jdbcDao;
    }
}
