package org.jsmth.jorm.logic;

import java.util.Comparator;

/**
 * 可供排序接口，类似于comparable，使用float作为排序值
 * @author mason
 */
public interface Sortable {

	public static final Comparator<Sortable> SORTABLE_COMPARATOR = new Comparator<Sortable>() {
		public int compare(Sortable o1, Sortable o2) {
            if(o1.getSortOrder()<o2.getSortOrder()){
                return -1;
            }
            else if(o1.getSortOrder()==o2.getSortOrder()){
                return 0;
            }
            else {
                return 1;
            }
		}
	};

	/**
	 * float类型作为排序的值，值越小排序位置越靠前，值越大排序位置越靠后
	 *
	 * @return 返回信息
	 */
	float getSortOrder();

}
