package org.jsmth.jorm.logic;

import org.jsmth.common.DictEnum;
import org.jsmth.util.DictHelper;

/**
 * User: mason
 * Date: 2010-2-5
 * Time: 13:29:08
 */
public enum EnvironmentState implements DictEnum {

    DEVELOP("开发模式", ""),
    TEST("测试模式", ""),
    INTEGRATION("集成测试模式", ""),
    PRODUCTION("生产模式", ""),;

    EnvironmentState(String display) {
        this.display = display;
    }

    EnvironmentState(String display, String memo) {
        this.display = display;
        this.memo = memo;
    }

    String display;
    String memo;

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    @Override
    public String getMemo() {
        return memo;
    }

    @Override
    public Enum<?> getDefault() {
        return DEVELOP;
    }

    public static EnvironmentState parse(String content) {
        return DictHelper.getEnum(EnvironmentState.class, content, true);
    }
    
}
