package org.jsmth.jorm.jdbc.schema;


import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Table;
import org.jsmth.util.ReflectUtil;

import javax.persistence.Entity;
import java.util.*;

/**
 * User: 马生录（mason
 * Date: 14-1-5
 * Time: 下午10:39
 */
public class TableSchema {
    Class entityClass;
    ColumnSchema idColumn;
    String tableName = "";
    Set<ColumnSchema> columns = new LinkedHashSet<ColumnSchema>();
    Map<String, ColumnSchema> columnsByColumnNameMap = new LinkedHashMap<String, ColumnSchema>();
    Map<String, ColumnSchema> columnsByFieldNameMap = new LinkedHashMap<String, ColumnSchema>();
    Map<String, ColumnSchema> columnsByLengthFieldNameMap = new LinkedHashMap<String, ColumnSchema>();

    List<ColumnSchema> embeddedColumnss = new LinkedList<ColumnSchema>();
    List<ColumnSchema> embeddingColumnss = new LinkedList<ColumnSchema>();
    Map<String, IndexSchema> indexes = new LinkedHashMap<String, IndexSchema>();

    public TableSchema() {
    }

    public TableSchema(Class entityClass) {
        this.entityClass = entityClass;
        this.tableName = getEntityTableName(entityClass);
    }
    public void updateColumnName(String fieldName,String newColumnName) {
        ColumnSchema columnSchema = columnsByFieldNameMap.get(fieldName);
        columnsByColumnNameMap.remove(columnSchema.getColumnName());
        columnSchema.setColumnName(newColumnName);
        columnsByColumnNameMap.put(newColumnName,columnSchema);
    }

    public void addColumn(ColumnSchema columnSchema) {
        //数据表名可以全都小写
        columnsByColumnNameMap.put(columnSchema.getColumnName().toLowerCase(), columnSchema);
        //属性名不能小写
        columnsByFieldNameMap.put(columnSchema.getFieldName(), columnSchema);

        columnsByLengthFieldNameMap.put(columnSchema.getLengthFieldName(), columnSchema);
        if (columnSchema.isEmbedding()) {
            embeddingColumnss.add(columnSchema);
        }
        if (columnSchema.isEmbedded()) {
            embeddedColumnss.add(columnSchema);
        } else {
            columns.add(columnSchema);
            if (columnSchema.isId()) {
                if (idColumn != null) {
                    throw new IllegalArgumentException("entity id is not one");
                }
                idColumn = columnSchema;
            }
        }
    }

    public ColumnSchema getColumnByFieldName(String fieldName) {
        if (columnsByFieldNameMap.containsKey(fieldName))
            return columnsByFieldNameMap.get(fieldName);
        return null;
    }

    public ColumnSchema getColumnByColumnName(String columnName) {
        columnName = columnName.toLowerCase();
        if (columnsByColumnNameMap.containsKey(columnName))
            return columnsByColumnNameMap.get(columnName);
        return null;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class getEntityClass() {
        return entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public ColumnSchema getIdColumn() {
        return idColumn;
    }

    public void setIdColumn(ColumnSchema idColumn) {
        this.idColumn = idColumn;
    }

    public Set<ColumnSchema> getColumns() {
        return columns;
    }

    public Map<String, IndexSchema> getIndexes() {
        return indexes;
    }

    public void setIndexes(Map<String, IndexSchema> indexes) {
        this.indexes = indexes;
    }

    public static String getEntityTableName(Class<?> entityClass) {
        Table table = ReflectUtil.getClassAnnotation(entityClass, Table.class);
        if (table != null) {
            if (!StringUtils.isBlank(table.appliesTo())) {
                return table.appliesTo();
            }
        }
        javax.persistence.Table javatable = ReflectUtil.getClassAnnotation(entityClass, javax.persistence.Table.class);
        if (javatable != null) {
            if (!StringUtils.isBlank(javatable.name())) {
                return javatable.name();
            }
        }
        Entity entity = ReflectUtil.getClassAnnotation(entityClass, Entity.class);
        if (entity != null) {
            if (!StringUtils.isBlank(entity.name())) {
                return entity.name();
            }
        }
        return entityClass.getSimpleName();
    }

    public Map<String, ColumnSchema> getColumnsByColumnNameMap() {
        return columnsByColumnNameMap;
    }

    public Map<String, ColumnSchema> getColumnsByFieldNameMap() {
        return columnsByFieldNameMap;
    }

    public List<ColumnSchema> getEmbeddingColumnss() {
        return embeddingColumnss;
    }

    public List<ColumnSchema> getEmbeddedColumnss() {
        return embeddedColumnss;
    }

    public static boolean isEntity(Class<?> entityClass) {
        Table table = ReflectUtil.getClassAnnotation(entityClass, Table.class);
        if (table != null) {
            return true;
        }
        javax.persistence.Table javatable = ReflectUtil.getClassAnnotation(entityClass, javax.persistence.Table.class);
        if (javatable != null) {
            return true;
        }
        Entity entity = ReflectUtil.getClassAnnotation(entityClass, Entity.class);
        if (entity != null) {
            return true;
        }
        return false;
    }


}
