package org.jsmth.jorm.jdbc.schema;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * User: 马生录（mason
 * Date: 14-1-5
 * Time: 下午11:01
 */
public class ObjectSchema {

    protected static Map<Class,TableSchema> tableCaches=new LinkedHashMap<Class, TableSchema>();
    public static TableSchema getTable(Class entityClass){
        if(tableCaches.containsKey(entityClass)){
            return tableCaches.get(entityClass);
        }
        TableSchema table=new TableSchema(entityClass);
        List<ColumnSchema> columnSchemas = loadColumns();
        for (ColumnSchema columnSchema : columnSchemas) {
            table.getColumns().add(columnSchema);
            table.getColumnsByColumnNameMap().put(columnSchema.getColumnName(), columnSchema);
            table.getColumnsByFieldNameMap().put(columnSchema.getFieldName(), columnSchema);
            if(columnSchema.isId()){
                if(table.getIdColumn()!=null){
                    throw  new IllegalArgumentException("entity id is not one");
                }
                table.setIdColumn(columnSchema);
            }
        }
        List<IndexSchema> indexSchemas = loadIndexs();
        for (IndexSchema indexSchema : indexSchemas) {
            table.getIndexes().put(indexSchema.getName(),indexSchema);
        }
        tableCaches.put(entityClass,table);
        return table;
    }

    protected static List<ColumnSchema> loadColumns(){
        return null;
    }
    protected static List<IndexSchema> loadIndexs(){
        return null;
    }

}
