package org.jsmth.jorm.jdbc.schema;

import org.jsmth.jorm.jdbc.Event;

import javax.persistence.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * User: 马生录（mason
 * Date: 14-1-5
 * Time: 下午11:09
 */
public class EventMapping {

    protected static Map<Class, Map<Event, Method>> objectEventCaches = new LinkedHashMap<Class, Map<Event, Method>>();

    /**
     * 获得实体上绑定的jpa事件
     *
     * @param clazz d
     * @param <T> d d
     * @return 返回信息
     */
    public static <T> Map<Event, Method> getEventMap(Class<T> clazz) {
        Class superclazz = clazz;
        Map<Event, Method> ret = new HashMap<Event, Method>();

        while (superclazz != null && !superclazz.equals(Object.class)) {
            Method[] methods = superclazz.getMethods();
            for (Method method : methods) {
                if (!ret.containsKey(Event.PreInsert) && method.getAnnotation(PrePersist.class) != null) {
                    ret.put(Event.PreInsert, method);
                } else if (!ret.containsKey(Event.PreUpdate) && method.getAnnotation(PreUpdate.class) != null) {
                    ret.put(Event.PreUpdate, method);
                } else if (!ret.containsKey(Event.PreDelete) && method.getAnnotation(PreRemove.class) != null) {
                    ret.put(Event.PreDelete, method);
                } else if (!ret.containsKey(Event.PostLoad) && method.getAnnotation(PostLoad.class) != null) {
                    ret.put(Event.PostLoad, method);
                } else if (!ret.containsKey(Event.PostInsert) && method.getAnnotation(PostPersist.class) != null) {
                    ret.put(Event.PostInsert, method);
                } else if (!ret.containsKey(Event.PostUpdate) && method.getAnnotation(PostUpdate.class) != null) {
                    ret.put(Event.PostUpdate, method);
                } else if (!ret.containsKey(Event.PostDelete) && method.getAnnotation(PostRemove.class) != null) {
                    ret.put(Event.PostDelete, method);
                }
            }
            superclazz = superclazz.getSuperclass();
        }
        return ret;
    }

    public void invokeEvent(Object target, Event event) {
        if (target == null) return;
        Class<?> entityClass = target.getClass();
        Map<Event, Method> events = null;
        if (objectEventCaches.containsKey(entityClass)) {
            events = objectEventCaches.get(entityClass);
        } else {
            events = getEventMap(entityClass);
            objectEventCaches.put(entityClass, events);
        }

        Method method = events.get(event);
        if (method != null) {
            try {
                method.invoke(target);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void batchInvokeEvent(Collection targets, Event event) {
        if (targets.isEmpty())
            return;

        Map<Event, Method> events = null;
        for (Object target : targets) {
            if (events == null) {
                Class<?> entityClass = target.getClass();
                if (objectEventCaches.containsKey(entityClass)) {
                    events = objectEventCaches.get(entityClass);
                } else {
                    events = getEventMap(entityClass);
                    objectEventCaches.put(entityClass, events);
                }
            }

            Method method = events.get(event);
            if (target == null) continue;

            try {
                method.invoke(target);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

}
