package org.jsmth.jorm.jdbc.schema;

import org.apache.commons.lang.StringUtils;
import org.jsmth.jorm.jdbc.ColumnType;
import org.jsmth.util.ReflectUtil;

import javax.persistence.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;

/**
 * User: 马生录（mason
 * Date: 14-1-5
 * Time: 下午10:39
 */
public class ColumnSchema {
    String columnName;
    String fieldName;
    String lengthFieldName;
    ColumnSchema embeddedColumn;
    Field field;
    boolean id=false;
    ColumnType columnType;
    Object[] enumValues;
    boolean embedded=false;
    boolean embedding=false;

    public ColumnSchema() {
    }

    public ColumnSchema(Field field) {
        this.field = field;
        columnName = getFieldColumnName(field);
        fieldName = field.getName();
        this.lengthFieldName=fieldName;
        columnType = getFieldType(field);
        id = isIdField(field);
        if (isEnumerate()) {
            Class<?> enumclazz = field.getType();
            try {
                Method valuesMethod = enumclazz.getDeclaredMethod("values");
                enumValues = (Object[]) valuesMethod.invoke(null);
            } catch (Exception e) {
                throw new RuntimeException("Error while accessing enum.values() for field[" + field + "]", e);
            }
        }

    }

    public static boolean getFieldIsAutoGenerated(Field field) {
        GeneratedValue generatedValue = ReflectUtil.getFieldAnnotation(field, GeneratedValue.class);
        if (generatedValue != null) {
            return true;
        }
        return false;
    }

    public static String getFieldColumnName(Field field) {
        Column column = ReflectUtil.getFieldAnnotation(field, Column.class);
        if (column != null) {
            if (!StringUtils.isBlank(column.name())) {
                return column.name();
            }
        }
        return field.getName();
    }

    public static boolean isIdField(Field field) {
        Id column = ReflectUtil.getFieldAnnotation(field, Id.class);
        if (column != null) {
            return true;
        }
        return false;
    }

    public Field getField() {
        return field;
    }

    public ColumnType getColumnType() {
        return columnType;
    }

    public String getColumnName() {
        return columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getFieldName() {
        return fieldName;
    }

    public Object[] getEnumValues() {
        return enumValues;
    }

    public boolean isEmbedding() {
        return embedding;
    }

    public void setEmbedding(boolean embedding) {
        this.embedding = embedding;
    }

    public ColumnSchema getEmbeddedColumn() {
        return embeddedColumn;
    }

    public void setEmbeddedColumn(ColumnSchema embeddedColumn) {
        this.embeddedColumn = embeddedColumn;
        this.lengthFieldName=embeddedColumn.getField().getType().getSimpleName()+"."+fieldName;
    }

    public String getLengthFieldName() {
        return lengthFieldName;
    }

    public  boolean isIdAutoIncrease() {
       return isIdAutoIncrease(field);
    }

    public boolean isId() {
        return id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public static ColumnType getFieldType(Field field) {
        Class clazz = field.getType();
        if (clazz.equals(int.class) || clazz.equals(Integer.class)) {
            return ColumnType.Int;
        }
        if (clazz.equals(long.class) || clazz.equals(Long.class)) {
            return ColumnType.Long;
        }
        if (clazz.equals(float.class) || clazz.equals(Float.class)) {
            return ColumnType.Int;
        }
        if (clazz.equals(double.class) || clazz.equals(Double.class)) {
            return ColumnType.Double;
        }
        if (clazz.equals(String.class)) {
            return ColumnType.string;
        }
        if (clazz.equals(Date.class) || clazz.equals(java.sql.Date.class)) {
            return ColumnType.date;
        }
        if (clazz.equals(char.class)){
            return ColumnType.Char;
        }
        if (clazz.equals(boolean.class) || clazz.equals(Boolean.class))
            return ColumnType.Boolean;
        if (clazz.isEnum()) {
            return isUseOrdinal(field) ? ColumnType.Int : ColumnType.string;
        }
        return null;
    }


    public static boolean isIdAutoIncrease(Field field) {
        GeneratedValue gv = field.getAnnotation(GeneratedValue.class);
        if (gv == null)
            return false;
        if (gv.strategy() == GenerationType.AUTO || gv.strategy() == GenerationType.IDENTITY)
            return true;
        throw new IllegalArgumentException("Unsupproted GeneratedValue strategy");
    }

    public boolean isEnumerate() {
        return isEnumerate(field);
    }

    public boolean isUseOrdinal() {
        return isUseOrdinal(field);
    }

    public static boolean isEnumerate(Field field) {
        return field.getType().isEnum();
    }

    public static boolean isUseOrdinal(Field field) {
        Enumerated ann = field.getAnnotation(Enumerated.class);
        return ann != null && ann.value() != EnumType.STRING;
    }
    public static boolean isEmbedded(Field field) {
          return field.getAnnotation(Embedded.class) != null;
      }

    public boolean isEmbedded() {
        return embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

}
