package org.jsmth.jorm.jdbc.query.where;

import org.jsmth.jorm.jdbc.query.WhereBy;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:07
 */
public class ThanWhereItem extends SqlItem {


    public ThanWhereItem(String fieldName, Object value) {
        this(fieldName, value, WhereBy.THAN_EQUAL);
    }

    public ThanWhereItem(String fieldName, Object value, int pattern) {
        build(fieldName, value, pattern);
    }

    public void build(String fieldName, Object value, int pattern) {
        sql = new StringBuilder();
        sql.append(getColumnNameSqlString(fieldName));
        switch (pattern) {
            case WhereBy.THAN_GREATER:
                sql.append(" > ?");
                break;
            case WhereBy.THAN_LESS:
                sql.append(" < ?");
                break;
            case WhereBy.THAN_EQUAL:
                sql.append(" = ?");
                break;
            case WhereBy.THAN_NOT:
                sql.append(" <> ?");
                break;
            case WhereBy.THAN_GREATER_EQUAL:
                sql.append(" >= ?");
                break;
            case WhereBy.THAN_LESS_EQUAL:
                sql.append(" <= ?");
                break;
            default:
                throw new UnsupportedOperationException("pattern fail.");
        }
        sqlParams.add(value);
    }

}
