package org.jsmth.jorm.jdbc.query.where;

/**
 * User: 马生录（mason
 * Date: 13-11-19
 * Time: 下午3:44
 */
public class LimitItem extends SqlItem {
    int pageNumber = 0;
    int pageSize;

    public final static int DEFAULT_PAGE_SIZE = 10;

    public LimitItem(int pageNumber) {
        this(pageNumber, DEFAULT_PAGE_SIZE);
    }

    public LimitItem(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public String toString() {
        if (pageNumber > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(" LIMIT ");
            builder.append(pageNumber);
            builder.append(" , ");
            builder.append(pageSize);
            builder.append(" ");
            return builder.toString();
        } else
            return "";
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
