package org.jsmth.jorm.jdbc.query.where;

import org.jsmth.jorm.jdbc.query.WhereBy;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:07
 */
public class LikeWhereItem extends SqlItem {
    public LikeWhereItem(String fieldName, Object value) {
        this(fieldName, value, WhereBy.LIKE_PREFIX);
    }

    public LikeWhereItem(String fieldName, Object value, int pattern) {
        build(fieldName, value, pattern);
    }

    public void build(String fieldName, Object value, int pattern) {
        sql = new StringBuilder();
        sql.append(getColumnNameSqlString(fieldName)).append(" like ");
        switch (pattern) {
            case WhereBy.LIKE_PREFIX:
                sql.append("'").append(value).append("%'");
                break;
            case WhereBy.LIKE_POSTFIX:
                sql.append("'%").append(value).append("'");
                break;
            case WhereBy.LIKE_KEYWORD:
                sql.append("'%").append(value).append("%'");
                break;
            default:
                throw new UnsupportedOperationException("pattern fail.");
        }
    }

}
