package org.jsmth.jorm.jdbc.query.where;

import java.util.Collection;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:08
 */
public class InWhereItem extends SqlItem {
    public InWhereItem(String fieldName, Object... values) {
        build(fieldName, values);
    }
    public InWhereItem(String fieldName, Collection collection) {
        build(fieldName, collection);
    }

    public void build(String fieldName, Object[] values) {
        sql = new StringBuilder();
        if (values.length > 0) {
            sql.append(getColumnNameSqlString(fieldName)).append(" in (");
            StringBuilder builder = new StringBuilder();
            for (Object value : values) {
                if (builder.length() > 0)
                    builder.append(",");
                builder.append("?");
                sqlParams.add(value);
            }
            sql.append(builder.toString());
            sql.append(" )");
        }
    }

    public void build(String fieldName, Collection collection) {
        sql = new StringBuilder();
        if (collection.size() > 0) {
            sql.append(getColumnNameSqlString(fieldName)).append(" in (");
            StringBuilder builder = new StringBuilder();
            for (Object value : collection) {
                if (builder.length() > 0)
                    builder.append(",");
                builder.append("?");
                sqlParams.add(value);
            }
            sql.append(builder.toString());
            sql.append(" )");
        }
    }

}
