package org.jsmth.jorm.jdbc.query;

import org.jsmth.jorm.jdbc.query.where.*;

import java.util.Collection;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:05
 */
public class WhereBy extends AbstractBuilder {

    public static final int MUST = 1;
    public static final int SHOULD = 2;
    public static final int MUST_NOT = 3;

    public static final int THAN_GREATER = 1;
    public static final int THAN_LESS = 2;
    public static final int THAN_EQUAL = 3;
    public static final int THAN_NOT = 4;
    public static final int THAN_GREATER_EQUAL = 5;
    public static final int THAN_LESS_EQUAL = 6;

    public static final int LIKE_PREFIX = 1;
    public static final int LIKE_POSTFIX = 2;
    public static final int LIKE_KEYWORD = 3;

    public WhereBy() {
    }


    public WhereBy addItem(SqlItem query) {
        return addItem(query, MUST);
    }

    public WhereBy addItem(SqlItem query, int occur) {
        if (sql.length() > 0) {
            sql.insert(0, "(");
            sql.append(")");
            switch (occur) {
                case MUST:
                    sql.append(" AND ");
                    break;
                case SHOULD:
                    sql.append(" OR ");
                    break;
                case MUST_NOT:
                    sql.append(" NOT ");
                    break;
                default:
                    throw new RuntimeException("occur value is fail");
            }
        }
        sql.append("(");
        sql.append(query.toString());
        sql.append(")");
        sqlParams.addAll(query.getSqlParams());
        return this;
    }

    public WhereBy addThanWhere(int occur, String fieldName, Object value) {
        ThanWhereItem item = new ThanWhereItem(fieldName, value);
        addItem(item, occur);
        return this;
    }

    public WhereBy addThanWhere(int occur, String fieldName, Object value, int pattern) {
        ThanWhereItem item = new ThanWhereItem(fieldName, value, pattern);
        addItem(item, occur);
        return this;
    }

    public WhereBy addInWhere(int occur, String fieldName, Collection collection) {
        InWhereItem item = new InWhereItem(fieldName, collection);
        addItem(item, occur);
        return this;
    }

    public WhereBy addInWhere(int occur, String fieldName, Object... values) {
        ThanWhereItem item = new ThanWhereItem(fieldName, values);
        addItem(item, occur);
        return this;
    }

    public WhereBy addLikeWhere(int occur, String fieldName, Object value) {
        LikeWhereItem item = new LikeWhereItem(fieldName, value);
        addItem(item, occur);
        return this;
    }

    public WhereBy addLikeWhere(int occur, String fieldName, Object value, int pattern) {
        LikeWhereItem item = new LikeWhereItem(fieldName, value, pattern);
        addItem(item, occur);
        return this;
    }

    public WhereBy addWhere(int occur, String fieldName, Object value) {
        TeamWhereItem item = new TeamWhereItem(fieldName, value);
        addItem(item, occur);
        return this;
    }

    public WhereBy addBetweenWhere(int occur, String fieldName1, Object value1, String fieldName2, Object value2) {
        BetweenWhereItem item = new BetweenWhereItem(fieldName1, value1, fieldName2, value2);
        addItem(item, occur);
        return this;
    }

    public WhereBy addBetweenWhere(int occur, String fieldName1, Object value1, int pattern1, String fieldName2, Object value2, int pattern2) {
        BetweenWhereItem item = new BetweenWhereItem(fieldName1, value1, pattern1, fieldName2, value2, pattern2);
        addItem(item, occur);
        return this;
    }

    public WhereBy addBetweenWhere(int occur, String fieldName1, Object value1, int pattern1, String fieldName2, Object value2, int pattern2, int betweenOccur) {
        BetweenWhereItem item = new BetweenWhereItem(fieldName1, value1, pattern1, fieldName2, value2, pattern2, betweenOccur);
        addItem(item, occur);
        return this;
    }

    @Override
    public String toString() {
        return sql.toString();
    }
}
