package org.jsmth.jorm.jdbc.query;

import java.util.LinkedList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-11-15
 * Time: 上午11:58
 */
public class UpdateBuilder extends AbstractBuilder {
    protected StringBuilder where;
    protected List setParams;
    protected List whereParams;

    public UpdateBuilder() {
        where = new StringBuilder();
        whereParams = new LinkedList();
        setParams = new LinkedList();
    }

    public UpdateBuilder addFieldValue(String fieldName, Object value) {
        if (sql.length() > 0) {
            sql.append(",");
        }
        sql.append(getColumnNameSqlString(fieldName)).append(" = ?");
        setParams.add(value);
        return this;
    }

    public UpdateBuilder addWhere(WhereBy whereBy) {
        where.append(whereBy.toString());
        whereParams.add(whereBy.getSqlParams());
        return this;
    }

    @Override
    public List getSqlParams() {
        List params = new LinkedList();
        params.add(setParams);
        params.add(whereParams);
        return params;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
                builder.append(" UPDATE ")
                        .append(tableName)
                        .append(" SET ")
                        .append(sql.toString());
                if (where.length() > 0) {
                    builder.append(" WHERE ")
                            .append(where.toString());
                }
                return builder.toString();
    }

}
