package org.jsmth.jorm.jdbc.query;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:05
 */
public class SelectBy extends AbstractBuilder {
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int LEN = 5;
    public static final int AVG = 6;
    public static final int FIRST = 7;
    public static final int LAST = 8;
    public static final int TEAM = 9;

    public static final int ALL = 10;


    protected boolean initAlled=false;

    public SelectBy addAll(){
        return  add("","", ALL);
    }
    public SelectBy add(String fieldName, int pattern){
        return  add(fieldName,"", pattern);
    }
    public SelectBy add(String fieldName, String aliasName, int pattern) {
        if (sql.length() > 0) {
            sql.append(",");
        }
        switch (pattern) {
            case TEAM:
                sql.append(getColumnNameSqlString(fieldName));
                break;
            case COUNT:
                sql.append(" count( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case SUM:
                sql.append(" sum( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case MIN:
                sql.append(" min( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case MAX:
                sql.append(" max( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case LEN:
                sql.append(" len( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case AVG:
                sql.append(" avg( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case FIRST:
                sql.append(" first( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case LAST:
                sql.append(" last( ").append(getColumnNameSqlString(fieldName)).append(")");
                break;
            case ALL:
                if(initAlled){
                    throw new RuntimeException("A SQL cannot have multiple *");
                }
                sql.append(" * ");
                initAlled=true;
                break;
            default:
                throw new RuntimeException("pattern value is fail");
        }
        if (aliasName != null && aliasName.length() > 0) {
            sql.append(" AS ").append(aliasName);
        }
        return this;
    }
}
