package org.jsmth.jorm.jdbc.query;

import org.jsmth.jorm.jdbc.query.where.LimitItem;
import org.jsmth.jorm.jdbc.query.where.SqlItem;

import java.util.LinkedList;

/**
 * User: 马生录（mason
 * Date: 13-11-12
 * Time: 上午11:05
 */
public class QueryBuilder extends AbstractBuilder {

    protected SelectBy selectby;
    protected WhereBy whereby;
    protected GroupBy groupby;
    protected OrderBy orderby;
    protected LimitItem limitItem;

    public QueryBuilder() {
        selectby = new SelectBy();
        whereby = new WhereBy();
        groupby = new GroupBy();
        orderby = new OrderBy();
        sqlParams = new LinkedList();
        limitItem = new LimitItem(0);
    }

    public QueryBuilder addLimit(int pageNumber) {
        limitItem = new LimitItem(pageNumber);
        return this;
    }

    public QueryBuilder addLimit(int pageNumber, int pageSize) {
        limitItem = new LimitItem(pageNumber, pageSize);
        return this;
    }

    public WhereBy addWhere(SqlItem query, int occur) {
        whereby.addItem(query, occur);
        return whereby;
    }

    public SelectBy addSelectAll() {
        return addSelect("", SelectBy.ALL);
    }

    public SelectBy addSelect(String fieldName, int pattern) {
        selectby.add(fieldName, pattern);
        return selectby;
    }

    public SelectBy addGroup(String fieldName, int pattern) {
        groupby.add(fieldName, pattern);
        return selectby;
    }

    public SelectBy addOrder(String fieldName, int pattern) {
        orderby.add(fieldName, pattern);
        return selectby;
    }

    public static QueryBuilder instance() {
        QueryBuilder builder = new QueryBuilder();
        return builder;
    }


    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (selectby.isEmpt()) {
            throw new RuntimeException("Select cannot SQL statement is empty.");
        }
        builder.append(" SELECT ")
                .append(selectby.toString())
                .append(" FROM ")
                .append(tableName);
        if (!whereby.isEmpt()) {
            builder.append(" WHERE ")
                    .append(whereby.toString());
        }
        if (!orderby.isEmpt()) {
            builder.append(" ORDER BY ")
                    .append(orderby.toString());
        }
        if (!groupby.isEmpt()) {
            builder.append(" GROUP BY ")
                    .append(groupby.toString());
        }
        if (limitItem.getPageNumber()>0) {
            builder.append(limitItem.toString());
        }
        return builder.toString();
    }

    public SelectBy getSelectby() {
        return selectby;
    }

    public void setSelectby(SelectBy selectby) {
        this.selectby = selectby;
    }

    public WhereBy getWhereby() {
        return whereby;
    }

    public void setWhereby(WhereBy whereby) {
        this.whereby = whereby;
    }

    public GroupBy getGroupby() {
        return groupby;
    }

    public void setGroupby(GroupBy groupby) {
        this.groupby = groupby;
    }

    public OrderBy getOrderby() {
        return orderby;
    }

    public void setOrderby(OrderBy orderby) {
        this.orderby = orderby;
    }
}
