package org.jsmth.jorm.jdbc.query;

/**
 * User: 马生录（mason
 * Date: 13-11-15
 * Time: 上午11:58
 */
public class InsertBuilder extends AbstractBuilder {
    protected StringBuilder fields;
    protected StringBuilder values;

    public InsertBuilder() {
        fields = new StringBuilder();
        values=new StringBuilder();
    }

    public static InsertBuilder instance(String fieldName, Object value) {
        InsertBuilder builder=new InsertBuilder();
        builder.addFieldValue(fieldName, value);
        return builder;
    }

    public InsertBuilder addFieldValue(String fieldName, Object value) {
        if (sql.length() > 0) {
            sql.append(",");
            values.append(",");
        }
        fields.append(getColumnNameSqlString(fieldName));
        values.append("?");
        sqlParams.add(value);
        return this;
    }


    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
               builder.append(" INSERT ")
                       .append(tableName)
                       .append(" ( ")
                       .append(fields.toString())
                       .append(" ) ")
                       .append(" VALUES ( ")
               .append(values.toString())
               .append(" ) ");
               return builder.toString();
    }
}
