package org.jsmth.jorm.jdbc.query;

import org.jsmth.jorm.jdbc.query.where.SqlItem;

/**
 * User: 马生录（mason
 * Date: 13-11-15
 * Time: 上午11:58
 */
public class DeleteBuilder extends AbstractBuilder {
    WhereBy where;

    public DeleteBuilder() {
        where=new WhereBy();
    }

    public static DeleteBuilder instance(SqlItem query, int occur) {
        DeleteBuilder builder=new DeleteBuilder();
        builder.addWhere(query, occur);
        return builder;
    }
    public DeleteBuilder addWhere(SqlItem query, int occur) {
        where.addItem(query, occur);
        return this;
    }

    public String buildSql(String tableName) {
        StringBuilder builder = new StringBuilder();
        builder.append(" DELETE FROM ")
                .append(tableName);
        if (sql.length() > 0) {
            builder.append(" WHERE ")
                    .append(sql.toString());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return buildSql("defaultTable");
    }
}
