package org.jsmth.jorm.jdbc;


import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.exception.SmthExceptionDict;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;

/**
 * 功能：
 * 马生录(mason) on 2015/10/14.
 */
public class SmthSimpleJdbcTemplate extends JdbcTemplate {
    public SmthSimpleJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }


    public int queryForInt(String sql, Map<String, ?> args) throws SmthDataAccessException {
        try {
            return super.queryForObject(sql,Integer.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public int queryForInt(String sql, SqlParameterSource args) throws SmthDataAccessException {
        try {
            return super.queryForObject(sql,Integer.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public int queryForInt(String sql, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql,Integer.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public long queryForLong(String sql, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql,Long.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public long queryForLong(String sql, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql,Long.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public long queryForLong(String sql, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql,Long.class, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, requiredType, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, requiredType, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, requiredType, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public <T> T queryForObject(String sql, RowMapper<T> rm, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }


    public <T> T queryForObject(String sql, RowMapper<T> rm, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }


    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rm, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForObject(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public <T> List<T> query(String sql, RowMapper<T> rm, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.query(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }


    public <T> List<T> query(String sql, RowMapper<T> rm, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.query(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }


    @Override
    public <T> List<T> query(String sql, RowMapper<T> rm, Object... args) throws SmthDataAccessException {

        try {
            return super.query(sql, rm, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }


    public Map<String, Object> queryForMap(String sql, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.queryForMap(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public Map<String, Object> queryForMap(String sql, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.queryForMap(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForMap(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.queryForList(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.queryForList(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object... args) throws SmthDataAccessException {

        try {
            return super.queryForList(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public int update(String sql, Map<String, ?> args) throws SmthDataAccessException {

        try {
            return super.update(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    public int update(String sql, SqlParameterSource args) throws SmthDataAccessException {

        try {
            return super.update(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    @Override
    public int update(String sql, Object... args) throws SmthDataAccessException {

        try {
            return super.update(sql, args);
        }
        catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }
}
