package org.jsmth.jorm.jdbc;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.exception.SmthExceptionDict;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 主从分离时，一组从库处理的jdbcDao，主要用于schema的调整
 * User: mason
 * Date: 2010-8-31
 * Time: 10:08:31
 */
public class SlaveJdbcDao extends JdbcDao {

    boolean cluster = false;
    String url;
    String vip;
    String driverClassName;
    String username;
    String password;
    String groupIps;
    Map<String, JdbcTemplate> templates;

    public SlaveJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    public SlaveJdbcDao(DataSource dataSource, String dialect, String schemaUpdateStrategy) {
        super(dataSource, dialect, schemaUpdateStrategy);
    }

    @Override
    public void executeDDL(String sql) throws SmthDataAccessException {
        try {
            if (cluster) {
                Map<String, JdbcTemplate> list = getTemplates();
                for (Map.Entry<String, JdbcTemplate> entry : list.entrySet()) {
                    entry.getValue().execute(sql);
                }
            } else {
                super.execute(sql);
            }
        }catch (DataAccessException ex){
            throw new SmthDataAccessException(SmthExceptionDict.DataAccessException,ex);
        }
    }

    private Map<String, JdbcTemplate> getTemplates() {
        if (templates == null) {
            synchronized (this) {
                if (templates == null) {
                    try {
                        String[] arr = groupIps.split(";");
                        templates = new LinkedHashMap<String, JdbcTemplate>(arr.length);
                        for (String s : arr) {
                            if (!StringUtils.isBlank(s)) {
                                String ss = url.replace(vip, s);
                                BasicDataSource ds = new BasicDataSource();
                                ds.setDriverClassName(driverClassName);
                                ds.setUsername(username);
                                ds.setPassword(password);
                                ds.setUrl(ss);
                                ds.setInitialSize(1);
                                ds.setMaxActive(1);
                                JdbcTemplate template = new JdbcTemplate(ds);
                                templates.put(ss, template);
                            }
                        }
                    } catch (Exception e) {
                        throw new IllegalArgumentException("slave jdbcDao configuration error.", e);
                    }
                }
            }
        }
        return templates;
    }

    @Override
    public void init() throws SmthDataAccessException {
        super.init();
        cluster = (vip != null && url != null && driverClassName != null && username != null && password != null && groupIps != null);
    }

    //gs

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVip() {
        return vip;
    }

    public void setVip(String vip) {
        this.vip = vip;
    }

    public String getDriverClassName() {
        return driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getGroupIps() {
        return groupIps;
    }

    public void setGroupIps(String groupIps) {
        this.groupIps = groupIps;
    }

    public boolean isCluster() {
        return cluster;
    }
}
