package org.jsmth.jorm.jdbc;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 暂时不使用
 *
 * @author mason
 */
@SuppressWarnings({"unchecked", "ConstantConditions", "UnusedDeclaration", "JavaDoc"})
public abstract class SQLHelper {



    //<editor-fold desc="and">
    public static void appendSql(StringBuilder sql, List sqlParams, String where,List params,boolean isAddBracket, int combineStyle){
        if(where==null || where.length()==0){
            return;
        }
        if(sql.length()>0){
            if(isAddBracket) {
                sql.insert(0, "(");
                sql.append(")");
            }
            switch (combineStyle){
                case COMBINR_OR:
                    sql.append(" or ");
                    break;
                case COMBINR_AND:
                    sql.append(" and ");
                    break;
                case COMBINR_NOT:
                    sql.append(" not ");
                    break;
            }
            if(isAddBracket) {
                sql.append("(");
            }
            sql.append(where);
            if(isAddBracket) {
                sql.append(")");
            }
        }else{
            sql.append(where);
        }
        sqlParams.addAll(params);
    }
    public static void andAppendSql(StringBuilder sql, List sqlParams, String where,List params,boolean isAddBracket){
        appendSql(sql, sqlParams, where, params,isAddBracket, COMBINR_AND);
    }
    public static void orAppendSql(StringBuilder sql, List sqlParams, String where,List params,boolean isAddBracket){
        appendSql(sql, sqlParams, where, params,isAddBracket, COMBINR_OR);
    }
    public static void notAppendSql(StringBuilder sql, List sqlParams, String where,List params,boolean isAddBracket){
        appendSql(sql, sqlParams, where, params,isAddBracket, COMBINR_NOT);
    }

    public static void andGreaterThan(StringBuilder sql, List sqlParams, String columnName, Object value){
    }
    //</editor-fold>
    //<editor-fold desc="or">
    //</editor-fold>
    //<editor-fold desc="not">
    //</editor-fold>
    //    public static Set<Class> findEntities(String parentPackageName) {
//
//    }

    public static final int COMBINR_OR = 1;
    public static final int COMBINR_AND = 2;
    public static final int COMBINR_NOT = 3;

    public static StringBuilder orCombine(StringBuilder sql1, List sqlParams1, StringBuilder sql2, List sqlParams2, List sqlParams) {
        return combine(sql1, sqlParams1, sql2, sqlParams2, sqlParams, COMBINR_OR);
    }
    public static StringBuilder andCombine(StringBuilder sql1, List sqlParams1, StringBuilder sql2, List sqlParams2, List sqlParams) {
        return combine(sql1, sqlParams1, sql2, sqlParams2, sqlParams, COMBINR_AND);
    }
    public static StringBuilder combine(StringBuilder sql1, List sqlParams1, StringBuilder sql2, List sqlParams2, List sqlParams, int combineStyle) {
        sqlParams.addAll(sqlParams1);
        sqlParams.addAll(sqlParams2);
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(sql1.toString());
        builder.append(")");
        switch (combineStyle){
            case COMBINR_OR:
                builder.append(" or ");
                break;
            case COMBINR_AND:
                builder.append(" and ");
                break;
            case COMBINR_NOT:
                builder.append(" not ");
                break;
        }
        builder.append("(");
        builder.append(sql2.toString());
        builder.append(")");
        return builder;
    }

    public static void combineAppend(StringBuilder sql, List sqlParams, int combineStyle, StringBuilder sql2, List sqlParams2) {
        sqlParams.addAll(sqlParams2);
        sql.insert(0,"(");
        sql.append(")");
        switch (combineStyle){
            case COMBINR_OR:
                sql.append(" or ");
                break;
            case COMBINR_AND:
                sql.append(" and ");
                break;
            case COMBINR_NOT:
                sql.append(" not ");
                break;
        }
        if(sql2!=null && sql2.toString().length()>0) {
            sql.append("(");
            sql.append(sql2.toString());
            sql.append(")");
        }
    }

    /**
     * 更新schema
     *
     * @param entityClass d
     * @param driverClassName d
     * @param username d
     * @param password d
     * @param urls d
     */
    public static void buildSchema(Class entityClass, String driverClassName, String username, String password, String... urls) {
        for (String url : urls) {
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(driverClassName);
            ds.setUsername(username);
            ds.setPassword(password);
            ds.setUrl(url);

            JdbcDao dao = new JdbcDao(ds, "MySQL5", "UPDATE");
            dao.updateSchema(entityClass);
        }
    }

    public static String pagingClause(int pageNumber, int pageSize) {
        if (pageSize < 0) pageSize = 0;
        if (pageNumber < 1) pageNumber = 1;
        return String.format(" limit %d,%d", ((pageNumber - 1) * pageSize), pageSize);
    }

    public static void appendGreaterThan(StringBuilder sql, List sqlParams, String columnName, Object prop) {
        appendGreaterThan(sql, sqlParams, columnName, prop, false);
    }

    public static void appendGreaterThan(StringBuilder sql, List sqlParams, String columnName, Object prop, boolean includeEquals) {
        if (prop != null) {
            if (includeEquals)
                sql.append(" and ").append(columnName).append(">=?");
            else
                sql.append(" and ").append(columnName).append(">?");
            sqlParams.add(prop);
        }
    }

    public static void appendLessThan(StringBuilder sql, List sqlParams, String columnName, Object prop) {
        appendLessThan(sql, sqlParams, columnName, prop, false);
    }

    public static void appendLessThan(StringBuilder sql, List sqlParams, String columnName, Object prop, boolean includeEquals) {
        if (prop != null) {
            if (includeEquals)
                sql.append(" and ").append(columnName).append("<=?");
            else
                sql.append(" and ").append(columnName).append("<?");
            sqlParams.add(prop);
        }
    }

    public static void appendEqual(StringBuilder sql, List sqlParams, String columnName, Object prop) {
        if (prop != null) {
            sql.append(" and ").append(columnName).append("=?");
            sqlParams.add(prop);
        }
    }

    public static void appendNotEqual(StringBuilder sql, List sqlParams, String columnName, Object prop) {
        if (prop != null) {
            sql.append(" and ").append(columnName).append("<>?");
            sqlParams.add(prop);
        }
    }

    @Deprecated
    public static void appendLike(StringBuilder sql, List sqlParams, String columnName, String prefix) {
        if (prefix != null) {
            sql.append(" and ").append(columnName).append(" like '").append(prefix).append("%'");
//            sqlParams.add(prefix);
        }
    }

    @Deprecated
    public static void appendPostLike(StringBuilder sql, List sqlParams, String columnName, String postfix) {
        if (postfix != null) {
            sql.append(" and ").append(columnName).append(" like '%").append(postfix).append("'");
//            sqlParams.add(postfix);
        }
    }


    public static void appendPrePostLike(StringBuilder sql, List sqlParams, String columnName, String postfix) {
        if (postfix != null) {
            sql.append(" and ").append(columnName).append(" like '%").append(postfix).append("%'");
//            sql.append(" and ").append(columnName).append(" like '%?%'");
//            sqlParams.add(postfix);
        }
    }

    public static void appendBetween(StringBuilder sql, List sqlParams, String columnName, Action action, Object start, Object end) {
        appendBetween(sql, sqlParams, columnName, action, start, true, end, true);
    }

    public static void appendBetween(StringBuilder sql, List sqlParams, String columnName, Action action, Object start, boolean startIncludeEquals, Object end, boolean endIncludeEquals) {
        if (start != null && end != null) {
            if (start.equals(end)) {
                sql.append(" and ").append(columnName).append("=?");
                sqlParams.add(action.getValue(start));

            } else {
                sql.append(" and ").append(columnName).append(">");
                if (startIncludeEquals)
                    sql.append("=");
                sql.append("? and ").append(columnName).append("<");
                if (endIncludeEquals)
                    sql.append("=");
                sql.append("?");
                sqlParams.add(action.getValue(start));
                sqlParams.add(action.getValue(end));
            }
        } else if (start != null && end == null) {
            sql.append(" and ").append(columnName).append(">");
            if (startIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(action.getValue(start));

        } else if (start == null && end != null) {
            sql.append(" and ").append(columnName).append("<");
            if (endIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(action.getValue(end));
        } else {
        }
    }

    public static void appendBetween(StringBuilder sql, List sqlParams, String columnName, Object start, Object end) {
        appendBetween(sql, sqlParams, columnName, start, true, end, true);
    }

    public static void appendBetween(StringBuilder sql, List sqlParams, String columnName, Object start, boolean startIncludeEquals, Object end, boolean endIncludeEquals) {
        if (start != null && end != null) {
            if (start.equals(end)) {
                sql.append(" and ").append(columnName).append("=?");
                sqlParams.add(start);

            } else {
                sql.append(" and ").append(columnName).append(">");
                if (startIncludeEquals)
                    sql.append("=");
                sql.append("? and ").append(columnName).append("<");
                if (endIncludeEquals)
                    sql.append("=");
                sql.append("?");
                sqlParams.add(start);
                sqlParams.add(end);
            }
        } else if (start != null && end == null) {
            sql.append(" and ").append(columnName).append(">");
            if (startIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(start);

        } else if (start == null && end != null) {
            sql.append(" and ").append(columnName).append("<");
            if (endIncludeEquals)
                sql.append("=");
            sql.append("?");
            sqlParams.add(end);
        } else {
        }
    }

    public static void appendStart(StringBuilder sql, List sqlParams, String columnName, Object start, boolean startIncludeEquals) {
        sql.append(" and ").append(columnName).append(">");
        if (startIncludeEquals)
            sql.append("=");
        sql.append("?");
        sqlParams.add(start);
    }

    public static void appendStop(StringBuilder sql, List sqlParams, String columnName, Object end, boolean startIncludeEquals) {
        sql.append(" and ").append(columnName).append("<");
        if (startIncludeEquals)
            sql.append("=");
        sql.append("?");
        sqlParams.add(end);
    }

    public static void appendIn(StringBuilder sql, List sqlParams, String columnName, List values) {
        appendIn(sql, sqlParams, columnName, values.toArray());
    }

    public static void appendIntegerIn(StringBuilder sql, List sqlParams, String columnName, List<Integer> values) {
        List params=new ArrayList();
        params.addAll(values);
        appendIn(sql,sqlParams,columnName,params.toArray());
    }
    public static void appendIntegerIn(StringBuilder sql, List sqlParams, String columnName, Integer... values) {
        List params=new ArrayList();
        if(values!=null){
            for (int value : values) {
                params.add(value);
            }
        }
        appendIn(sql,sqlParams,columnName,params.toArray());
    }
    public static void appendIntIn(StringBuilder sql, List sqlParams, String columnName, int... values) {
        List params=new ArrayList();
        if(values!=null){
            for (int value : values) {
                params.add(value);
            }
        }
        appendIn(sql,sqlParams,columnName,params.toArray());
    }
    public static void appendIn(StringBuilder sql, List sqlParams, String columnName, Object... values) {
        if (ArrayUtils.isEmpty(values) || values.length==0) {
            sql.append(" and 'in'='null'");
            return ;
        }

        sql.append(" and ").append(columnName).append(" in(");
        for (Object value : values) {
            if (value != null) {
                sql.append("?,");
                sqlParams.add(value);
            }
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
    }

    public static void appendNotIn(StringBuilder sql, List sqlParams, String columnName, List values) {
        appendNotIn(sql, sqlParams, columnName, values.toArray());
    }

    public static void appendNotIn(StringBuilder sql, List sqlParams, String columnName, Object... values) {
        if (ArrayUtils.isEmpty(values)) {
            sql.append(" and 'in'='null'");
            return ;
        }

        sql.append(" and ").append(columnName).append(" not in(");
        for (Object value : values) {
            if (value != null) {
                sql.append("?,");
                sqlParams.add(value);
            }
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
    }

    public static void appendOrder(StringBuilder sql, List sqlParams, String columnName, boolean asc) {
        sql.append(" order by ").append(columnName).append(asc ? " asc " : " desc ");
    }

    public static void appendOrder(StringBuilder sql, List sqlParams, String columnName1, boolean asc1, String columnName2, boolean asc2) {
        sql.append(" order by ").append(columnName1).append(asc1 ? " asc " : " desc ");
        sql.append(",").append(columnName2).append(asc2 ? " asc " : " desc ");
    }

    public static void appendOrder(StringBuilder sql, List sqlParams, Map<String, Boolean> columnOrders) {
        sql.append(" order by ");
        for (Map.Entry<String, Boolean> entry : columnOrders.entrySet()) {
            sql.append(",").append(entry.getKey()).append(entry.getValue() ? " asc " : " desc ");
        }
    }

    public static void appendPaging(StringBuilder sql, List sqlParams, int pageNumber, int pageSize) {
        sql.append(pagingClause(pageNumber, pageSize));
    }

    public static String inClause(String columnName, int paramSize) {
        StringBuilder sql = new StringBuilder();
        sql.append(columnName);
        sql.append(" in (");
        for (int i = 0; i < paramSize; i++) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String whereAddColumn(String columnName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" and ").append(columnName).append(" = ?");
        return sql.toString();
    }


    /**
     * 将SQL查询语句去掉排序和select子句后，转化为求和语句 暂时不支持union
     *
     * @param sql d
     * @return 返回信息
     */
    public static String getCountSQL(String sql) {
        return " select count (*) " + removeSelect(removeOrders(sql));
    }

    /**
     * 去除sql的select 子句，未考虑union的情况,用于pagedQuery.
     * @param sql d
     * @return d
     * 
     */
    public static String removeSelect(String sql) {
        Assert.hasText(sql);
        if (sql.toLowerCase().indexOf("union") > 0) {
            throw new IllegalArgumentException("Unsupported SQL [" + sql + "] for count.");
        }
        int beginPos = sql.toLowerCase().indexOf("from");
        Assert.isTrue(beginPos != -1, "sql [" + sql + "] must has a keyword 'from'");
        return sql.substring(beginPos);
    }

    /**
     * 将SQL查询语句去掉排序和select子句后，转化为求和语句 暂时不支持union
     *
     * @param sql d
     * @return 返回信息
     */
    public static String getDisctinctCountSQL(String sql) {
        Assert.hasText(sql);
        if (sql.toLowerCase().indexOf("union") > 0) {
            throw new IllegalArgumentException("Unsupported SQL [" + sql + "] for count.");
        }
        int beginPos = sql.toLowerCase().indexOf("distinct");
        int endPos = sql.toLowerCase().indexOf("from");
        Assert.isTrue(endPos != -1, "sql [" + sql + "] must has a keyword 'from'");
        String entityName = sql.substring(beginPos + 8, endPos).trim();
        sql = sql.replaceFirst("distinct", "");
        sql = sql.replaceFirst(entityName, "count(distinct " + entityName + ".id) ");
        return sql;
    }

    /**
     * 去除sql的orderby 子句，用于pagedQuery.
     * @param sql d
     * @return d
     * 
     */
    public static String removeOrders(String sql) {
        Assert.hasText(sql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", Pattern.CASE_INSENSITIVE);
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public interface Action {
        Object getValue(Object bean);
    }
}
